/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.slashArt;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.SkillHandle;
import net.exmo.rough_blade.content.SlashAttackHandle;
import net.exmo.rough_blade.content.specialEffects.CherryBlossomMarkHandle;
import net.exmo.rough_blade.entity.SakuraAttackEffectEntity;
import net.exmo.rough_blade.entity.SakuraExplosionEntity;
import net.exmo.rough_blade.entity.SakuraSlashEntity;
import net.exmo.rough_blade.init.ComboStateRegistry;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.utils.ExUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SakuraBloomSa {
    public static final int STAGE_1_DURATION = 10;
    public static final int STAGE_2_DURATION = 30;
    public static final int STAGE_3_DURATION = 60;
    public static final int STAGE_1_COST = 15;
    public static final int STAGE_2_COST = 25;
    public static final int STAGE_3_COST = 50;
    public static final int DEFAULT_SA_COST = 0;

    public static void onUse(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        ISlashBladeState slashBlade = ExUtils.getSlashBlade(mainHandItem);
        if (slashBlade != null) {
            int chargeTime = SlashAttackHandle.the_last_use_elapsedTime;
            int sakuraValue = CherryBlossomMarkHandle.getSakuraValue(player);
            if (sakuraValue >= 15) {
                SakuraBloomSa.executeStage1(player, mainHandItem);
                CherryBlossomMarkHandle.decreaseSakuraValue(player, 15);
            } else if (sakuraValue >= 0) {
                CareerSkill.changeCombo(mainHandItem, ComboStateRegistry.SAKURA_BLOOM_DEFAULT_SA.getId(), (LivingEntity)player);
                CherryBlossomMarkHandle.decreaseSakuraValue(player, 0);
            }
        }
    }

    public static void executeDefaultSA(Player player, ItemStack weapon) {
        Level level = player.m_9236_();
        CherryBlossomMarkHandle.onSimpleLoveAttack(player, (LivingEntity)player, 0.8);
        CherryBlossomMarkHandle.onSimpleLoveAttack(player, (LivingEntity)player, 0.8);
        player.m_6330_(SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 1.0f);
        player.m_6330_(SoundEvents.f_11693_, SoundSource.PLAYERS, 0.6f, 1.2f);
        Vec3 lookVec = player.m_20154_();
        Vec3 playerPos = player.m_20182_();
        Vec3 dir1 = SakuraBloomSa.rotateVectorAroundY(lookVec, 0.0);
        SakuraBloomSa.spawnSakuraSlash(player, level, playerPos, dir1);
        Rough_blade.queueServerWork(1, () -> {
            Vec3 dir2 = SakuraBloomSa.rotateVectorAroundY(lookVec, 0.0);
            SakuraBloomSa.spawnSakuraSlash(player, level, playerPos, dir2);
        });
    }

    public static void spawnSakuraSlash(Player player, Level level, Vec3 startPos, Vec3 direction) {
        if (!level.f_46443_) {
            SakuraSlashEntity slashEntity = new SakuraSlashEntity(RBEntityRegistry.SAKURA_SLASH_ENTITY, level);
            slashEntity.m_6034_(startPos.f_82479_, startPos.f_82480_ + (double)player.m_20192_() * 0.8, startPos.f_82481_);
            slashEntity.setOwner((LivingEntity)player);
            slashEntity.setDamage(player.m_21133_(Attributes.f_22281_) * 8.0);
            double speed = 1.2;
            slashEntity.m_20334_(direction.f_82479_ * speed, direction.f_82480_ * 0.8, direction.f_82481_ * speed);
            level.m_7967_((Entity)slashEntity);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, startPos.f_82479_, startPos.f_82480_ + (double)player.m_20192_() * 0.8, startPos.f_82481_, 15, 0.2, 0.2, 0.2, 0.1);
        }
    }

    public static void executeStage1(Player player, ItemStack weapon) {
        Level level = player.m_9236_();
        Vec3 startPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_().m_82541_();
        Vec3 endPos = SkillHandle.findFarthestNonAirBlock((LivingEntity)player, 12.0).m_252807_();
        player.m_6330_(SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_6330_(SoundEvents.f_11693_, SoundSource.PLAYERS, 0.5f, 1.2f);
        SakuraBloomSa.showPathParticles(level, startPos, endPos, 0.5);
        player.m_6021_(endPos.f_82479_, endPos.f_82480_ + 0.5, endPos.f_82481_);
        Vec3 diff = endPos.m_82546_(startPos);
        double distance = diff.m_82553_();
        Vec3 normalizedDiff = diff.m_82541_();
        AABB pathBox = new AABB(startPos, endPos).m_82377_(1.0, 1.0, 1.0);
        for (Entity entity : level.m_45933_((Entity)player, pathBox)) {
            Vec3 closestPoint;
            double distToPath;
            Vec3 entityVec;
            double projection;
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == player || !((projection = (entityVec = new Vec3(entity.m_20185_() - startPos.f_82479_, entity.m_20186_() - startPos.f_82480_, entity.m_20189_() - startPos.f_82481_)).m_82526_(normalizedDiff)) >= 0.0) || !(projection <= distance) || !((distToPath = (closestPoint = startPos.m_82549_(normalizedDiff.m_82490_(projection))).m_82554_(entity.m_20182_())) < 1.5)) continue;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List randomNumbers = IntStream.rangeClosed(1, 13).boxed().collect(Collectors.toList());
                Collections.shuffle(randomNumbers);
                for (int i = 0; i < 6; ++i) {
                    int finalI = (Integer)randomNumbers.get(i);
                    Rough_blade.queueServerWork(i * 2, () -> SakuraBloomSa.spawnSakuraEffect(player, weapon, finalI, target, serverLevel));
                }
                target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 0));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() / 2.0, target.m_20189_(), 10, 0.2, 0.2, 0.2, 0.1);
            }
            CherryBlossomMarkHandle.addCherryBlossomMark(target, 1);
        }
    }

    public static void spawnSakuraEffect(Player owner, ItemStack weapon, int amplifier, LivingEntity livingEntity, ServerLevel serverLevel) {
        SakuraAttackEffectEntity sakuraEffect = new SakuraAttackEffectEntity(RBEntityRegistry.SAKURA_ATTACK_EFFECT, livingEntity.m_9236_());
        RandomSource random = serverLevel.f_46441_;
        double xOffset = random.m_188500_() * 0.3;
        double yOffset = (double)random.m_188501_() * 0.3;
        double zOffset = (double)random.m_188501_() * 0.3;
        sakuraEffect.m_6034_(livingEntity.m_20185_() + xOffset, livingEntity.m_20186_() + 1.0 + yOffset, livingEntity.m_20189_() + zOffset);
        sakuraEffect.setAmp(amplifier % 12);
        serverLevel.m_7967_((Entity)sakuraEffect);
        sakuraEffect.f_19802_ = 0;
        if (owner == null) {
            return;
        }
        sakuraEffect.m_5602_((Entity)owner);
        DamageSource damageSource = new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)owner);
        int invulnerableTime = livingEntity.f_19802_;
        livingEntity.f_19802_ = 0;
        double attributeValue = owner.m_21133_(Attributes.f_22281_);
        livingEntity.m_6469_(damageSource, (float)((double)(amplifier + 1) * (attributeValue + 6.0) * 5.0 + (double)livingEntity.m_21233_() * 1.5E-4));
        livingEntity.f_19802_ = invulnerableTime;
    }

    private static Vec3 rayTraceForCollision(Level level, Vec3 start, Vec3 direction, double maxDistance) {
        Vec3 end = start.m_82549_(direction.m_82490_(maxDistance));
        int steps = (int)(maxDistance * 4.0);
        for (int i = 0; i <= steps; ++i) {
            Vec3 checkPos = start.m_82549_(direction.m_82490_(maxDistance * (double)i / (double)steps));
            if (!level.m_8055_(BlockPos.m_274446_((Position)checkPos)).m_280555_()) continue;
            return checkPos.m_82546_(direction.m_82490_(0.5));
        }
        return end;
    }

    private static void showPathParticles(Level level, Vec3 start, Vec3 end, double stepSize) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 diff = end.m_82546_(start);
        double distance = diff.m_82553_();
        Vec3 step = diff.m_82541_().m_82490_(stepSize);
        int steps = (int)(distance / stepSize);
        for (int i = 0; i < steps; ++i) {
            Vec3 pos = start.m_82549_(step.m_82490_((double)i));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 6, 0.1, 0.1, 0.1, 0.05);
        }
    }

    public static void executeStage2(Player player, ItemStack weapon) {
        Level level = player.m_9236_();
        Vec3 center = player.m_20182_();
        double radius = 5.0;
        player.m_6330_(SoundEvents.f_11894_, SoundSource.PLAYERS, 1.0f, 0.8f);
        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 0.7f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            Rough_blade.queueServerWork(i * 2, () -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int j = 0; j < 360; j += 15) {
                        double angleRad = Math.toRadians(j);
                        double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                        double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                        double x = center.f_82479_ + Math.cos(angleRad) * radius + offsetX;
                        double z = center.f_82481_ + Math.sin(angleRad) * radius + offsetZ;
                        double y = center.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.5;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, x, y, z, 3, 0.1, 0.1, 0.1, 0.05);
                    }
                }
            });
        }
        AABB area = new AABB(center.f_82479_ - radius, center.f_82480_ - 2.0, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + 2.0, center.f_82481_ + radius);
        for (Entity entity : level.m_45933_((Entity)player, area)) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == player) continue;
            Vec3 knockbackVec = target.m_20182_().m_82546_(center).m_82541_().m_82542_(1.5, 0.5, 1.5);
            target.m_20334_(knockbackVec.f_82479_, knockbackVec.f_82480_, knockbackVec.f_82481_);
            target.f_19864_ = true;
            int marksToAdd = 2 + level.f_46441_.m_188503_(2);
            CherryBlossomMarkHandle.addCherryBlossomMark(target, marksToAdd);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() / 2.0, target.m_20189_(), 15, 0.2, 0.2, 0.2, 0.1);
        }
    }

    public static void executeStage3(Player player, ItemStack weapon) {
        Level level = player.m_9236_();
        Vec3 startPos = player.m_20182_();
        Vec3 lookVec = player.m_20154_();
        player.m_6330_(SoundEvents.f_12555_, SoundSource.PLAYERS, 1.5f, 0.8f);
        player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        double coneAngle = 60.0;
        int numExplosions = 8;
        double distance = 6.0;
        for (int i = 0; i < numExplosions; ++i) {
            double angleOffset = (level.f_46441_.m_188500_() - 0.5) * Math.toRadians(coneAngle);
            Vec3 rotatedLookVec = SakuraBloomSa.rotateVectorAroundY(lookVec, angleOffset);
            Vec3 explosionPos = startPos.m_82549_(rotatedLookVec.m_82542_(distance, distance, distance));
            if (level.f_46443_) continue;
            SakuraExplosionEntity explosion = new SakuraExplosionEntity(RBEntityRegistry.SAKURA_EXPLOSION_ENTITY, level);
            explosion.m_6034_(explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_);
            explosion.setShooter((Entity)player);
            explosion.setRadius(2.5f);
            explosion.setExplosionCount(3);
            explosion.setDamage(8.0f);
            level.m_7967_((Entity)explosion);
        }
    }

    public static Vec3 rotateVectorAroundY(Vec3 vec, double angleRad) {
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        return new Vec3(vec.f_82479_ * cos - vec.f_82481_ * sin, vec.f_82480_, vec.f_82479_ * sin + vec.f_82481_ * cos);
    }

    public static enum SkillStage {
        INITIAL,
        CHARGING_1,
        CHARGING_2,
        CHARGING_3,
        DEFAULT_SA;

    }
}

