/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.slashArt;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.CareerSkillInstant;
import net.exmo.rough_blade.content.ExSkillHelper;
import net.exmo.rough_blade.content.SkillHandle;
import net.exmo.rough_blade.content.SpecialEffectEx;
import net.exmo.rough_blade.content.specialEffects.MingLiEffectHandle;
import net.exmo.rough_blade.entity.FallenStarEntity;
import net.exmo.rough_blade.init.RBEntityRegistry;
import net.exmo.rough_blade.init.RBSpecialEffectRegistry;
import net.exmo.rough_blade.network.LSVARB;
import net.exmo.rough_blade.utils.AutoInit;
import net.exmo.rough_blade.utils.ExUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
@AutoInit
public class FallenStarSaPlus
extends CareerSkill {
    public FallenStarSaPlus() {
        super("FallenStarSa");
        this.CoolDown = 1200;
        this.Icon = Items.f_42686_;
        this.LocalDescription = "KaiSkill_d";
    }

    @SubscribeEvent
    public static void MulitAttribute(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof ItemSlashBlade) {
            ExSkillHelper exSkillHelper;
            ItemSlashBlade slashBlade = (ItemSlashBlade)item;
            if (SpecialEffectEx.hasSpecialEffect(event.getItemStack(), RBSpecialEffectRegistry.StarrySky.getId()) && (exSkillHelper = ExSkillHelper.of(event.getItemStack())).getSkillsSize() == 0) {
                exSkillHelper.addSkill(CareerSkillInstant.of(SkillHandle.getSkill("StarDashSa"), 1), true);
                exSkillHelper.addSkill(CareerSkillInstant.of(SkillHandle.getSkill("FallenStarSa"), 1), true);
            }
        }
    }

    @Override
    public boolean use(Player player) {
        if (player.m_9236_().f_46443_) {
            return false;
        }
        if (super.use(player)) {
            FallenStarSaPlus.changeCombo(player.m_21205_(), ComboStateRegistry.COMBO_A2.getId(), (LivingEntity)player);
            LSVARB.PlayerVariables playerVariables = ExUtils.getPlayerVariables(player);
            List<LSVARB.playerSimpleVar<?>> playerSimpleVars = playerVariables.playerSimpleVars;
            playerSimpleVars.get(4).setValue("slash_art.fallen_star");
            playerVariables.syncPlayerVariables((Entity)player);
            Rough_blade.queueServerWork(200, () -> {
                List<LSVARB.playerSimpleVar<?>> playerSimpleVars;
                LSVARB.PlayerVariables playerVariables = ExUtils.getPlayerVariables(player);
                if (player instanceof ServerPlayer && ((String)(playerSimpleVars = playerVariables.playerSimpleVars).get(4).getValue()).contains("slash_art.fallen_star")) {
                    playerSimpleVars.get(4).setValue(playerSimpleVars.get(4).getDefaultValue());
                    playerVariables.syncPlayerVariables((Entity)player);
                }
            });
            Level level = player.m_9236_();
            FallenStarSaPlus.doSlash((LivingEntity)player, 5.0f);
            return true;
        }
        return false;
    }

    public static void doSlash(LivingEntity livingEntity, float damage) {
        Vec3 _center = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        Level level = livingEntity.m_9236_();
        livingEntity.getPersistentData().m_128350_("ZhenLiDamage", (float)livingEntity.m_21133_(Attributes.f_22281_));
        List<Entity> _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(10.0), a -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (!(entityiterator instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entityiterator;
            if (entityiterator == livingEntity) continue;
            MingLiEffectHandle.addZhenLi(le);
            le.getPersistentData().m_128359_("ZhenLiO", livingEntity.m_20148_().toString());
        }
        FallenStarSaPlus.generateRealisticMeteorShower(livingEntity, level);
    }

    private static void generateRealisticMeteorShower(LivingEntity livingEntity, Level level) {
        Random random = new Random();
        Vec3 playerPos = livingEntity.m_20182_();
        int showerDuration = 600;
        int spawnInterval = 3;
        int baseMeteorsPerInterval = 2;
        double meteorSpawnChance = 0.7;
        Vec3 playerLook = livingEntity.m_20154_();
        double radiantDistance = 100.0;
        Vec3 radiantPoint = new Vec3(playerPos.f_82479_ + playerLook.f_82479_ * radiantDistance, playerPos.f_82480_ + 60.0 + random.nextDouble() * 40.0, playerPos.f_82481_ + playerLook.f_82481_ * radiantDistance);
        AtomicInteger meteorCount = new AtomicInteger(0);
        for (int tick = 0; tick < showerDuration; tick += spawnInterval) {
            int currentTick = tick;
            Rough_blade.queueServerWork(currentTick, () -> {
                int meteorsThisRound = baseMeteorsPerInterval;
                if (random.nextDouble() < meteorSpawnChance) {
                    meteorsThisRound += random.nextInt(3);
                }
                int i = 0;
                while (i < meteorsThisRound) {
                    int finalI = i++;
                    Rough_blade.queueServerWork(finalI, () -> {
                        double radiantOffsetX = (random.nextDouble() - 0.5) * 30.0;
                        double radiantOffsetZ = (random.nextDouble() - 0.5) * 30.0;
                        double radiantOffsetY = (random.nextDouble() - 0.5) * 20.0;
                        Vec3 actualRadiant = new Vec3(radiantPoint.f_82479_ + radiantOffsetX, Math.max(radiantPoint.f_82480_ + radiantOffsetY, playerPos.f_82480_ + 30.0), radiantPoint.f_82481_ + radiantOffsetZ);
                        double flightDistance = 60.0 + random.nextDouble() * 80.0;
                        double flightAngle = random.nextDouble() * Math.PI * 2.0;
                        double flightHeightVariation = (random.nextDouble() - 0.5) * 30.0;
                        Vec3 flightDirection = new Vec3(Math.cos(flightAngle), flightHeightVariation * 0.1, Math.sin(flightAngle)).m_82541_();
                        Vec3 targetPoint = new Vec3(actualRadiant.f_82479_ + flightDirection.f_82479_ * flightDistance, actualRadiant.f_82480_ + flightHeightVariation, actualRadiant.f_82481_ + flightDirection.f_82481_ * flightDistance);
                        FallenStarEntity meteor = new FallenStarEntity(RBEntityRegistry.FALLEN_STAR_ENTITY, level);
                        double startX = actualRadiant.f_82479_ + (random.nextDouble() - 0.5) * 15.0;
                        double startY = actualRadiant.f_82480_ + (random.nextDouble() - 0.5) * 10.0;
                        double startZ = actualRadiant.f_82481_ + (random.nextDouble() - 0.5) * 15.0;
                        meteor.m_6034_(startX, startY, startZ);
                        meteor.m_5602_((Entity)livingEntity);
                        Vec3 direction = targetPoint.m_82492_(startX, startY, startZ).m_82541_();
                        double distance = targetPoint.m_82554_(new Vec3(startX, startY, startZ));
                        int lifetime = (int)(distance * 2.0) + 60;
                        meteor.setLifetime(Math.min(lifetime, 300));
                        double baseSpeed = 1.2 + random.nextDouble() * 0.8;
                        double speedVariation = 0.7 + random.nextDouble() * 0.6;
                        double finalSpeed = baseSpeed * speedVariation;
                        Vec3 velocityWithJitter = direction.m_82520_((random.nextDouble() - 0.5) * 0.15, (random.nextDouble() - 0.5) * 0.05, (random.nextDouble() - 0.5) * 0.15).m_82541_().m_82490_(finalSpeed);
                        meteor.m_20256_(velocityWithJitter);
                        meteor.getPersistentData().m_128379_("IsMeteorShower", true);
                        meteor.getPersistentData().m_128405_("MeteorNumber", meteorCount.incrementAndGet());
                        if (finalSpeed > 1.8) {
                            meteor.getPersistentData().m_128350_("MeteorScale", 1.2f);
                            meteor.getPersistentData().m_128379_("IsBright", true);
                            meteor.getPersistentData().m_128405_("TrailIntensity", 3);
                        } else {
                            meteor.getPersistentData().m_128350_("MeteorScale", 0.8f + random.nextFloat() * 0.4f);
                            meteor.getPersistentData().m_128379_("IsBright", false);
                            meteor.getPersistentData().m_128405_("TrailIntensity", 1);
                        }
                        String meteorType = random.nextDouble() < 0.2 ? "fireball" : "normal";
                        meteor.getPersistentData().m_128359_("MeteorType", meteorType);
                        level.m_7967_((Entity)meteor);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175827_, startX, startY, startZ, 8, 0.5, 0.5, 0.5, 0.05);
                            if (random.nextDouble() < 0.3) {
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, startX, startY, startZ, 5, 0.3, 0.3, 0.3, 0.02);
                            }
                            if (random.nextDouble() < 0.1) {
                                serverLevel.m_6263_(null, (double)((int)startX), (double)((int)startY), (double)((int)startZ), SoundEvents.f_11929_, SoundSource.AMBIENT, 0.3f, 0.8f + random.nextFloat() * 0.4f);
                            }
                        }
                    });
                }
            });
        }
        Rough_blade.queueServerWork(showerDuration + 20, () -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6263_(null, (double)((int)playerPos.f_82479_), (double)((int)playerPos.f_82480_), (double)((int)playerPos.f_82481_), SoundEvents.f_11935_, SoundSource.AMBIENT, 0.4f, 0.6f);
            }
        });
    }
}

