/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.screen;

import net.exmo.rough_blade.Config;
import net.exmo.rough_blade.config.ClientConfigs;
import net.exmo.rough_blade.init.RBAttribute;
import net.exmo.rough_blade.network.LSVARB;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class PowerBarOverlay
implements IGuiOverlay {
    public static final PowerBarOverlay instance = new PowerBarOverlay();
    public static final ResourceLocation TEXTURE = new ResourceLocation("rough_blade", "textures/gui/icons.png");
    static final int DEFAULT_IMAGE_WIDTH = 98;
    static final int XP_IMAGE_WIDTH = 188;
    static final int IMAGE_HEIGHT = 21;
    static final int HOTBAR_HEIGHT = 25;
    static final int ICON_ROW_HEIGHT = 11;
    static final int CHAR_WIDTH = 6;
    static final int HUNGER_BAR_OFFSET = 50;
    static final int SCREEN_BORDER_MARGIN = 20;
    static final int TEXT_COLOR = ChatFormatting.RED.m_126665_();

    public void render(ForgeGui gui, GuiGraphics guiHelper, float partialTick, int screenWidth, int screenHeight) {
        if (!((Boolean)Config.POWER.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!PowerBarOverlay.shouldShowManaBar((Player)player)) {
            return;
        }
        int maxMana = (int)player.m_21133_((Attribute)RBAttribute.Max_Slash_Power.get());
        int mana = (Integer)((LSVARB.PlayerVariables)player.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY).orElse(null)).playerSimpleVars.get(0).getValue();
        int configOffsetY = (Integer)ClientConfigs.MANA_BAR_Y_OFFSET.get();
        int configOffsetX = (Integer)ClientConfigs.MANA_BAR_X_OFFSET.get();
        Anchor anchor = (Anchor)((Object)ClientConfigs.MANA_BAR_ANCHOR.get());
        if (anchor == Anchor.XP && player.m_108634_() > 0.0f) {
            return;
        }
        int barX = PowerBarOverlay.getBarX(anchor, screenWidth) + configOffsetX;
        int barY = PowerBarOverlay.getBarY(anchor, screenHeight, gui) - configOffsetY;
        int imageWidth = anchor == Anchor.XP ? 188 : 98;
        int spriteX = anchor == Anchor.XP ? 68 : 0;
        int spriteY = anchor == Anchor.XP ? 40 : 0;
        guiHelper.m_280163_(TEXTURE, barX, barY, (float)spriteX, (float)spriteY, imageWidth, 21, 256, 256);
        guiHelper.m_280218_(TEXTURE, barX, barY, spriteX, spriteY + 21, (int)((double)imageWidth * Math.min((double)mana / (double)maxMana, 1.0)), 21);
        String manaFraction = mana + "/" + maxMana;
        int textX = (Integer)ClientConfigs.MANA_TEXT_X_OFFSET.get() + barX + imageWidth / 2 - (int)(((double)("" + mana).length() + 0.5) * 6.0);
        int textY = (Integer)ClientConfigs.MANA_TEXT_Y_OFFSET.get() + barY + (anchor == Anchor.XP ? 3 : 11);
        if (((Boolean)ClientConfigs.MANA_BAR_TEXT_VISIBLE.get()).booleanValue()) {
            guiHelper.m_280488_(gui.m_93082_(), manaFraction, textX, textY, TEXT_COLOR);
        }
    }

    public static boolean shouldShowManaBar(Player player) {
        Display display = (Display)((Object)ClientConfigs.MANA_BAR_DISPLAY.get());
        LSVARB.PlayerVariables playerVariables = (LSVARB.PlayerVariables)player.getCapability(LSVARB.PLAYER_VARIABLES_CAPABILITY).orElse(null);
        if (playerVariables == null) {
            return false;
        }
        return !player.m_5833_() && display != Display.Never && (display == Display.Always || (double)((Integer)playerVariables.playerSimpleVars.get(0).getValue()).intValue() < player.m_21133_((Attribute)RBAttribute.Max_Slash_Power.get()) || player.m_21093_(itemStack -> ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().contains("slashblade")));
    }

    private static int getBarX(Anchor anchor, int screenWidth) {
        if (anchor == Anchor.XP) {
            return screenWidth / 2 - 91 - 3;
        }
        if (anchor == Anchor.Hunger || anchor == Anchor.Center) {
            return screenWidth / 2 - 49 + (anchor == Anchor.Center ? 0 : 50);
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.BottomLeft) {
            return 20;
        }
        return screenWidth - 20 - 98;
    }

    private static int getBarY(Anchor anchor, int screenHeight, ForgeGui gui) {
        if (anchor == Anchor.XP) {
            return screenHeight - 32 + 3 - 8;
        }
        if (anchor == Anchor.Hunger) {
            return screenHeight - (PowerBarOverlay.getAndIncrementRightHeight(gui) - 2) - 10;
        }
        if (anchor == Anchor.Center) {
            return screenHeight - 25 - 27 - 10;
        }
        if (anchor == Anchor.TopLeft || anchor == Anchor.TopRight) {
            return 20;
        }
        return screenHeight - 20 - 21;
    }

    private static int getAndIncrementRightHeight(ForgeGui gui) {
        int x = gui.rightHeight;
        gui.rightHeight += 10;
        return x;
    }

    public static enum Anchor {
        Hunger,
        XP,
        Center,
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight;

    }

    public static enum Display {
        Never,
        Always,
        Contextual;

    }
}

