/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.CareerSkillInstant;
import net.exmo.rough_blade.content.ExSkillHelper;
import net.exmo.rough_blade.init.CareerWarModKeyMappings;
import net.exmo.rough_blade.network.CareerWarModVariables;
import net.exmo.rough_blade.utils.UiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class SkillBarOverlay
implements IGuiOverlay {
    public static final SkillBarOverlay INSTANCE = new SkillBarOverlay();
    static int screenHeight;
    static int screenWidth;
    private static final Map<String, Long> skillAnimationMap;
    private static final Map<Integer, String> keyMap;
    static final float ICON_SCALE = 1.1f;
    static final int ICON_SIZE = 20;
    static final int SCALED_SIZE = 22;
    static final int SPACING = 6;

    public static void triggerSkillAnimation(String skillName) {
        skillAnimationMap.put(skillName, System.currentTimeMillis());
    }

    public void render(ForgeGui gui, GuiGraphics gg, float partialTick, int w, int h) {
        CareerSkill careerSkill;
        h -= 20;
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        ItemStack mainHandItem = entity.m_21205_();
        if (!mainHandItem.m_41782_()) {
            return;
        }
        ExSkillHelper exSkillHelper = ExSkillHelper.of(mainHandItem);
        List<CareerSkillInstant> skills = exSkillHelper.getSkills();
        if (skills.isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screenWidth = w;
        screenHeight = h;
        CareerWarModVariables.PlayerVariables v = (CareerWarModVariables.PlayerVariables)entity.getCapability(CareerWarModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new CareerWarModVariables.PlayerVariables());
        int totalWidth = skills.size() * 28 - 6;
        int startX = (screenWidth - totalWidth) / 2;
        int startY = screenHeight - 68;
        HashMap map = new HashMap();
        for (int i = 0; i < skills.size() && (careerSkill = skills.get((int)i).careerSkill) != null; ++i) {
            int xPos = startX + i * 28;
            int yPos = startY;
            boolean isAnimating = false;
            float animationProgress = 0.0f;
            if (skillAnimationMap.containsKey(careerSkill.LocalName)) {
                long startTime = skillAnimationMap.get(careerSkill.LocalName);
                long elapsed = System.currentTimeMillis() - startTime;
                animationProgress = Math.min((float)elapsed / 300.0f, 1.0f);
                if (animationProgress >= 1.0f) {
                    skillAnimationMap.remove(careerSkill.LocalName);
                } else {
                    isAnimating = true;
                }
            }
            gg.m_280168_().m_85836_();
            gg.m_280168_().m_252880_((float)xPos, (float)yPos, 0.0f);
            if (isAnimating) {
                float scaleFactor = 1.0f + 0.3f * (1.0f - animationProgress);
                gg.m_280168_().m_85841_(scaleFactor, scaleFactor, 1.0f);
                gg.m_280168_().m_252880_(-((scaleFactor - 1.0f) * 20.0f / 2.0f), -((scaleFactor - 1.0f) * 20.0f / 2.0f), 0.0f);
            }
            ResourceLocation skillBg = new ResourceLocation("rough_blade:textures/screens/skill_bg.png");
            gg.m_280163_(skillBg, 0, 0, 0.0f, 0.0f, 20, 20, 20, 20);
            if (careerSkill.IconTexture != null) {
                gg.m_280168_().m_85836_();
                gg.m_280168_().m_85841_(1.1f, 1.1f, 1.0f);
                gg.m_280163_(careerSkill.IconTexture, 1, 1, 0.0f, 0.0f, 16, 16, 16, 16);
                gg.m_280168_().m_85849_();
            } else if (careerSkill.Icon != null) {
                gg.m_280168_().m_85836_();
                gg.m_280168_().m_85841_(1.1f, 1.1f, 1.0f);
                gg.m_280480_(careerSkill.Icon.m_7968_(), 1, 1);
                gg.m_280168_().m_85849_();
            }
            if (v.playercooldown.containsKey(careerSkill.LocalName) && v.playercooldown.get(careerSkill.LocalName) > 0) {
                float cooldownPercent = (float)v.playercooldown.get(careerSkill.LocalName).intValue() / (float)careerSkill.CoolDown;
                int cooldownHeight = Math.max((int)(19.0f * cooldownPercent), 0);
                gg.m_280246_(0.0f, 0.0f, 0.0f, 0.6f);
                gg.m_280509_(1, 1, 19, 19, Integer.MIN_VALUE);
                gg.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                gg.m_280246_(0.2f, 0.2f, 0.8f, 0.6f);
                gg.m_280509_(1, 1, 19, cooldownHeight + 1, Color.DARK_GRAY.getRGB());
                gg.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                float secondsLeft = (float)v.playercooldown.get(careerSkill.LocalName).intValue() / 40.0f;
                String formattedSeconds = String.format("%.1f", Float.valueOf(secondsLeft));
                if (secondsLeft > 0.0f) {
                    String cooldownText = formattedSeconds;
                    int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(cooldownText);
                    UiUtil.renderLineStr(gg, List.of(cooldownText), Minecraft.m_91087_().f_91062_, textWidth / 2 + 2, 6, 0xFFFFFF, Integer.MIN_VALUE, UiUtil.displaystyle.center);
                }
            }
            gg.m_280168_().m_85849_();
            if (i >= 4 || !keyMap.containsKey(i)) continue;
            String keyText = keyMap.get(i);
            Integer i1 = Integer.valueOf(keyText);
            if (i1 == 1) {
                keyText = CareerWarModKeyMappings.SKILL_1.m_90863_().getString();
            }
            if (i1 == 2) {
                keyText = CareerWarModKeyMappings.SKILL_2.m_90863_().getString();
            }
            if (i1 == 3) {
                keyText = CareerWarModKeyMappings.SKILL_3.m_90863_().getString();
            }
            if (i1 == 4) {
                keyText = CareerWarModKeyMappings.SKILL_4.m_90863_().getString();
            }
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(keyText);
            int keyX = xPos + (20 - textWidth) / 2;
            int keyY = yPos + 20 + 2;
            gg.m_280509_(keyX - 2, keyY - 2, keyX + textWidth + 2, keyY + 10, Integer.MIN_VALUE);
            gg.m_280056_(Minecraft.m_91087_().f_91062_, keyText, keyX, keyY, 16766720, false);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        skillAnimationMap = new HashMap<String, Long>();
        keyMap = new HashMap<Integer, String>();
        keyMap.put(0, "1");
        keyMap.put(1, "2");
        keyMap.put(2, "3");
        keyMap.put(3, "4");
        keyMap.put(4, "5");
    }
}

