/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content.client;

import net.exmo.rough_blade.content.SpecialEffectEx;
import net.exmo.rough_blade.content.specialEffects.CherryBlossomMarkHandle;
import net.exmo.rough_blade.init.RBSpecialEffectRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class SakuraValueOverlay
implements IGuiOverlay {
    public static final SakuraValueOverlay INSTANCE = new SakuraValueOverlay();
    private static final int MAX_SAKURA_VALUE = 100;
    private static final int BAR_WIDTH = 180;
    private static final int BAR_HEIGHT = 7;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!SpecialEffectEx.hasSpecialEffect(player.m_21205_(), RBSpecialEffectRegistry.The_Simple_Love.getId())) {
            return;
        }
        int sakuraValue = CherryBlossomMarkHandle.getSakuraValue((Player)player);
        if (sakuraValue <= 0) {
            return;
        }
        int barX = screenWidth - 180 - 10;
        int barY = screenHeight - 50;
        guiGraphics.m_280509_(barX, barY, barX + 180, barY + 7, Integer.MIN_VALUE);
        float fillRatio = (float)sakuraValue / 100.0f;
        int fillWidth = (int)(180.0f * fillRatio);
        int fillColor = this.getColorForValue(sakuraValue);
        guiGraphics.m_280509_(barX, barY, barX + fillWidth, barY + 7, fillColor);
        guiGraphics.m_280509_(barX, barY, barX + 180, barY + 1, -11912626);
        guiGraphics.m_280509_(barX, barY + 7 - 1, barX + 180, barY + 7, -11912626);
        guiGraphics.m_280509_(barX, barY, barX + 1, barY + 7, -11912626);
        guiGraphics.m_280509_(barX + 180 - 1, barY, barX + 180, barY + 7, -11912626);
        String text = "\u6a31\u534e: " + sakuraValue + "/100";
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(text);
        int textX = barX + (180 - textWidth) / 2;
        int textY = barY - 10;
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, textX, textY, -1, true);
    }

    private int getColorForValue(int value) {
        float ratio = (float)value / 100.0f;
        int r = 255;
        int g = (int)(182.0f - 62.0f * ratio);
        int b = (int)(193.0f - 43.0f * ratio);
        int a = 220;
        return a << 24 | r << 16 | g << 8 | b;
    }
}

