/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.content.CareerHandle;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.CareerSkillInstant;
import net.exmo.rough_blade.content.ExSkillHelper;
import net.exmo.rough_blade.network.CareerWarModVariables;
import net.exmo.rough_blade.network.DashMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillHandle {
    public static List<CareerSkill> registeredSkills = new ArrayList<CareerSkill>();

    public static CareerSkill getSkill(String name) {
        for (CareerSkill skill : registeredSkills) {
            if (!skill.LocalName.equals(name)) continue;
            return skill;
        }
        return null;
    }

    public static void sendParticleCircleN(ServerLevel level, Vec3 pos, SimpleParticleType particleType, float radius, int count) {
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < count; ++i) {
            double angle = (double)i * (Math.PI * 2 / (double)count);
            double offsetX = (double)radius * Math.cos(angle);
            double offsetZ = (double)radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)particleType, pos.f_82479_ + (offsetX += random.m_188500_() * 0.1 - 0.05), pos.f_82480_ + 0.5, pos.f_82481_ + (offsetZ += random.m_188500_() * 0.1 - 0.05), 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public static void orbitAroundEntity(Entity follower, Entity leader, double radius, float speed) {
        Vec3 leaderPos = leader.m_20182_();
        Vec3 followerPos = follower.m_20182_();
        double offsetX = followerPos.f_82479_ - leaderPos.f_82479_;
        double offsetZ = followerPos.f_82481_ - leaderPos.f_82481_;
        double currentAngle = Math.toDegrees(Math.atan2(offsetZ, offsetX)) - 90.0;
        double newAngle = currentAngle + (double)speed;
        double newX = leaderPos.f_82479_ + radius * Math.cos(Math.toRadians(newAngle));
        double newZ = leaderPos.f_82481_ + radius * Math.sin(Math.toRadians(newAngle));
        follower.m_6034_(newX, leaderPos.f_82480_, newZ);
        float yaw = (float)newAngle;
        follower.m_146922_(yaw);
        follower.m_5616_(yaw);
    }

    public static void sendParticleCircle(ServerLevel level, Entity entity, SimpleParticleType particleType, float radius, int count) {
        double posX = entity.m_20185_();
        double posY = entity.m_20186_() + (double)entity.m_20206_() * 0.5;
        double posZ = entity.m_20189_();
        for (int i = 0; i < count; ++i) {
            double angle = CareerHandle.random.nextDouble() * 2.0 * Math.PI;
            double offsetX = (double)radius * Math.cos(angle);
            double offsetZ = (double)radius * Math.sin(angle);
            level.m_8767_((ParticleOptions)particleType, posX + (offsetX += (CareerHandle.random.nextDouble() - 0.5) * 0.2), posY, posZ + (offsetZ += (CareerHandle.random.nextDouble() - 0.5) * 0.2), 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public static void moveTowardsBlockPos(Entity entity, BlockPos targetPos, double speed, double maxDistance) {
        Vec3 entityPos = entity.m_20182_();
        Vec3 targetVec = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        Vec3 diff = targetVec.m_82546_(entityPos);
        double dist = diff.m_82553_();
        if (dist <= maxDistance) {
            entity.m_6021_(targetVec.f_82479_, targetVec.f_82480_, targetVec.f_82481_);
            return;
        }
        Vec3 moveVec = diff.m_82541_().m_82490_(speed);
        Vec3 newPos = entityPos.m_82549_(moveVec);
        if (newPos.m_82554_(entityPos) > maxDistance) {
            newPos = entityPos.m_82549_(diff.m_82541_().m_82490_(maxDistance));
        }
        entity.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    public static Integer getSkillV(Player player, String SN) {
        Integer[] return_v = new Integer[]{0};
        player.getCapability(CareerWarModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            Map<String, Integer> m = capability.playercooldown;
            return_v[0] = m.getOrDefault(SN, 0);
        });
        return return_v[0];
    }

    public static void ChangeSkillV(Player player, String SN, int amout) {
        player.getCapability(CareerWarModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            Map<String, Integer> m = capability.playercooldown;
            if (m.containsKey(SN)) {
                m.replace(SN, amout);
            } else {
                m.put(SN, amout);
            }
            capability.playercooldown = m;
            capability.syncPlayerVariables((Entity)player);
        });
    }

    public static BlockPos findFarthestNonAirBlock(LivingEntity entity, double maxDistance) {
        BlockPos hitPos;
        Block block;
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePosition;
        Level world = entity.m_9236_();
        BlockHitResult result = world.m_45547_(new ClipContext(eyePosition = entity.m_20299_(1.0f), endPos = eyePosition.m_82549_(lookVec = entity.m_20252_(1.0f).m_82490_(maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (result.m_6662_() == HitResult.Type.BLOCK && (block = world.m_8055_(hitPos = result.m_82425_()).m_60734_()) != Blocks.f_50016_) {
            return hitPos;
        }
        return BlockPos.m_274446_((Position)endPos);
    }

    private static void sendParticle(Player player, ServerLevel level, Vec3 pos, SimpleParticleType particleType) {
        float yaw = player.m_146908_();
        double dx = -Math.sin(Math.toRadians(yaw)) * 0.5;
        double dz = Math.cos(Math.toRadians(yaw)) * 0.5;
        level.m_8767_((ParticleOptions)particleType, pos.f_82479_, pos.f_82480_ - 1.5, pos.f_82481_, 2, dx, 0.0, dz, 0.01);
    }

    public static void generateSphereParticles(ServerLevel level, SimpleParticleType particleType, Vec3 center, float radius, int count, @Nullable double vy, @Nullable double sp) {
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = center.f_82479_ + (double)((random.nextFloat() * 2.0f - 1.0f) * radius);
            if (!SkillHandle.isPointInSphere(center, x, y = center.f_82480_ + (double)((random.nextFloat() * 2.0f - 1.0f) * radius), z = center.f_82481_ + (double)((random.nextFloat() * 2.0f - 1.0f) * radius), radius)) continue;
            level.m_8767_((ParticleOptions)particleType, x, y, z, 1, 0.0, vy, 0.0, sp);
        }
    }

    private static boolean isPointInSphere(Vec3 center, double x, double y, double z, float radius) {
        double dx = x - center.f_82479_;
        double dy = y - center.f_82480_;
        double dz = z - center.f_82481_;
        return dx * dx + dy * dy + dz * dz <= (double)(radius * radius);
    }

    public static void sendDashMessage(Player player, double dy, double dashDistance) {
        DashMessage message = new DashMessage(dy, dashDistance);
        if (player.m_9236_().f_46443_) {
            return;
        }
        Rough_blade.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)message);
    }

    public static void generateSemicircleParticles(ServerPlayer player, float radius, SimpleParticleType particleType) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        float yaw = player.m_146908_();
        int angleStart = 0;
        int angleEnd = 180;
        int numberOfParticles = 10;
        double angleIncrement = (angleEnd - angleStart) / numberOfParticles;
        for (int i = 0; i < numberOfParticles; ++i) {
            double angle = (double)angleStart + (double)i * angleIncrement;
            double x = (double)radius * Math.cos(Math.toRadians(angle + (double)yaw));
            double z = (double)radius * Math.sin(Math.toRadians(angle + (double)yaw));
            Vec3 particlePos = playerPos.m_82520_(x, 1.0, z);
            SkillHandle.sendParticle((Player)player, level2, particlePos, particleType);
        }
    }

    public static void RegisterSkill(CareerSkill skill) {
        if (skill.LocalName != null) {
            registeredSkills.add(skill);
            Rough_blade.LOGGER.info("Registered Skill: " + skill.LocalName);
        } else {
            Rough_blade.LOGGER.error("Skill name is null");
        }
    }

    public static void useSkill(Player entity, int skill) {
        List<CareerSkillInstant> skills;
        ItemStack mainHandItem;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.f_8941_.m_9290_().equals((Object)GameType.SPECTATOR)) {
                return;
            }
        }
        if (!(mainHandItem = entity.m_21205_()).m_41782_()) {
            return;
        }
        CareerWarModVariables.PlayerVariables entityvars = (CareerWarModVariables.PlayerVariables)entity.getCapability(CareerWarModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new CareerWarModVariables.PlayerVariables());
        ExSkillHelper exSkillHelper = ExSkillHelper.of(mainHandItem);
        if (exSkillHelper != null && !(skills = exSkillHelper.getSkills()).isEmpty() && skill < skills.size() && skills.get(skill) != null) {
            skills.get((int)skill).careerSkill.use(entity);
        }
    }

    public static void vmove(LivingEntity livingEntity, double dy, double dashDistance) {
        float yaw = livingEntity.m_146908_();
        double dx = -Math.sin(Math.toRadians(yaw)) * dashDistance;
        double dz = Math.cos(Math.toRadians(yaw)) * dashDistance;
        livingEntity.m_20256_(new Vec3(dx, dy, dz));
    }

    public static void vmove2(LivingEntity livingEntity, double dy, double dashDistance) {
        float yaw = livingEntity.m_146908_();
        double dx = -Math.sin(Math.toRadians(yaw)) * dashDistance;
        double dz = Math.cos(Math.toRadians(yaw)) * dashDistance;
        livingEntity.m_246865_(new Vec3(dx, dy, dz));
    }
}

