/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.CareerSkillInstant;
import net.exmo.rough_blade.content.ExHelper;
import net.exmo.rough_blade.content.SkillHandle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ExSkillHelper
extends ExHelper {
    public final String EEID = "skills";

    public ExSkillHelper(ItemStack itemStack) {
        super(itemStack);
    }

    public static ExSkillHelper of(ItemStack itemStack) {
        return new ExSkillHelper(itemStack);
    }

    public boolean ValidElementEntry() {
        return this.ValidMainNbt() && this.getMainNbt().m_128441_("skills");
    }

    public ExSkillHelper createElementNbt() {
        this.createNbt();
        if (this.ValidElementEntry()) {
            return this;
        }
        this.getMainNbt().m_128365_("skills", (Tag)new ListTag());
        return this;
    }

    public List<CareerSkillInstant> getSkills() {
        CompoundTag tag;
        ArrayList<CareerSkillInstant> skills = new ArrayList<CareerSkillInstant>();
        if (this.ValidMainNbt() && (tag = this.getMainNbt()).m_128441_("skills")) {
            ListTag elementList = tag.m_128437_("skills", 10);
            for (int i = 0; i < elementList.size(); ++i) {
                CompoundTag tag1 = elementList.m_128728_(i);
                CareerSkill skill = SkillHandle.getSkill(tag1.m_128461_("skills"));
                if (skill == null) continue;
                int level = 1;
                if (tag1.m_128441_("Level")) {
                    level = tag1.m_128451_("Level");
                }
                CompoundTag tag2 = tag1.m_6426_();
                tag2.m_128473_("Level");
                skills.add(CareerSkillInstant.of(skill, level));
            }
        }
        return skills;
    }

    public boolean gatherElement(CareerSkillInstant skillInstant) {
        List<CareerSkillInstant> elementInstants = this.getSkills();
        AtomicInteger level = new AtomicInteger(skillInstant.getLevel());
        elementInstants.forEach(x -> {
            if (x.getCareerSkill().LocalName.equals(skillInstant.getCareerSkill().getLocalName())) {
                level.set(skillInstant.getLevel() + x.getLevel());
            }
        });
        if (level.get() == skillInstant.getLevel()) {
            return false;
        }
        this.removeSkill(skillInstant);
        this.addSkill(new CareerSkillInstant(skillInstant.getCareerSkill(), level.get()), false);
        return level.get() != skillInstant.getLevel();
    }

    public ListTag getElementsNbt() {
        return this.getMainNbt().m_128437_("skills", 10);
    }

    public ExSkillHelper removeSkill(CareerSkillInstant skillInstant) {
        this.createNbt();
        if (!this.ValidMainNbt()) {
            return this;
        }
        ListTag elementsNbt = this.getElementsNbt();
        for (int i = 0; i < elementsNbt.size(); ++i) {
            CompoundTag tag1 = elementsNbt.m_128728_(i);
            if (!tag1.m_128461_("skills").equals(skillInstant.getCareerSkill().getLocalName())) continue;
            elementsNbt.remove(i);
            break;
        }
        return this;
    }

    public ExSkillHelper addSkill(CareerSkillInstant exElementInstant, boolean gather) {
        if (exElementInstant.getCareerSkill() == null) {
            return this;
        }
        this.createNbt();
        if (!this.ValidMainNbt()) {
            this.createMainNbt();
        }
        this.createElementNbt();
        if (gather && this.gatherElement(exElementInstant)) {
            return this;
        }
        CompoundTag tag1 = new CompoundTag();
        tag1.m_128359_("skills", exElementInstant.getCareerSkill().getLocalName());
        tag1.m_128405_("Level", exElementInstant.getLevel());
        ListTag modifiersList = this.getElementsNbt();
        modifiersList.add((Object)tag1);
        return this;
    }

    public int getSkillsSize() {
        CompoundTag mainNbt = this.getMainNbt();
        if (!this.ValidMainNbt()) {
            return 0;
        }
        return mainNbt.m_128437_("skills", 10).size();
    }
}

