/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content;

import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exmo.rough_blade.Rough_blade;
import net.exmo.rough_blade.events.LoadCustomArtsCostsEvent;
import net.exmo.rough_blade.utils.ExConfig;
import net.exmo.rough_blade.utils.ExConfigHandle;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomConfig {
    public static Map<String, Integer> SlashArtsCostMap;

    public static void init() {
        SlashArtsCostMap = new HashMap<String, Integer>();
        MinecraftForge.EVENT_BUS.post((Event)new LoadCustomArtsCostsEvent(new addFunction()));
    }

    public static class addFunction {
        public addFunction add(String name, int cost) {
            SlashArtsCostMap.put(name, cost);
            Rough_blade.LOGGER.debug("load custom sa cost: {} {}", (Object)name, (Object)cost);
            return this;
        }

        public void copyResourceToFile(String resourcePath, String targetPath) {
            File mcDir = FMLPaths.GAMEDIR.get().toFile();
            File targetDir = new File(mcDir, targetPath).getParentFile();
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw new IllegalStateException("Could not create directory: " + targetDir.getAbsolutePath());
            }
            File targetFile = new File(targetDir, new File(targetPath).getName());
            try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
                if (in == null) {
                    throw new IOException("Resource not found: " + resourcePath);
                }
                Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy file from " + resourcePath + " to " + String.valueOf(targetFile), e);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class commonEvent {
        public static final String Config_path = FMLPaths.CONFIGDIR.get().resolve("exmo/sa_power/").toString();
        public static List<ExConfig> Foundmoconfigs = new ArrayList<ExConfig>();

        @SubscribeEvent
        public static void onReload(AddReloadListenerEvent event) {
            CustomConfig.init();
        }

        @SubscribeEvent
        public static void LoadFromConfig(LoadCustomArtsCostsEvent event) throws IOException {
            Foundmoconfigs = new ArrayList<ExConfig>();
            Path path = Path.of(Config_path, new String[0]);
            if (!new File(FMLPaths.GAMEDIR.get().resolve(path).toString()).exists()) {
                event.addFunction.copyResourceToFile("/data/rough_blade/default.json", "config/exmo/sa_power/default.json");
            }
            Foundmoconfigs = ExConfigHandle.listFiles(path);
            addFunction addFunction2 = event.addFunction;
            for (ExConfig exConfig : Foundmoconfigs) {
                commonEvent.processSAPower(exConfig, addFunction2);
            }
        }

        private static void processSAPower(ExConfig exConfig, addFunction addFunction2) {
            try {
                for (Map.Entry<String, JsonElement> entry : exConfig.readEntrys()) {
                    addFunction2.add(entry.getKey(), entry.getValue().getAsInt());
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

