/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.rough_blade.content;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.exmo.rough_blade.content.CareerSkill;
import net.exmo.rough_blade.content.SkillHandle;
import net.exmo.rough_blade.network.CareerWarModVariables;
import net.exmo.rough_blade.utils.AutoInit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CareerHandle {
    public static final Random random = new Random();

    public static void init() throws Exception {
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) throws Exception {
        SkillHandle.registeredSkills = new ArrayList<CareerSkill>();
        CareerHandle.init();
        CareerHandle.load(CareerSkill.class);
    }

    private static <T> T getPlugin(String className, Class<T> type2) {
        try {
            Class<?> asmClass = Class.forName(className);
            if (!type2.isAssignableFrom(asmClass)) {
                return null;
            }
            Class<T> asmInstanceClass = asmClass.asSubclass(type2);
            Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            return instance;
        }
        catch (LinkageError | ReflectiveOperationException e) {
            System.err.println("Failed to load plugin: " + className);
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Collection<T> load(Class<T> pluginInterface) {
        ArrayList<T> plugins = new ArrayList<T>();
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                String memberName;
                T plugin;
                if (!Objects.equals(a.annotationType(), Type.getType(AutoInit.class)) || (plugin = CareerHandle.getPlugin(memberName = a.memberName(), pluginInterface)) == null) continue;
                plugins.add(plugin);
            }
        }
        return plugins;
    }

    @Mod.EventBusSubscriber
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onQ(LivingDropsEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                event.getDrops().forEach(item -> {
                    ItemStack item1 = item.m_32055_();
                    if (item1.m_41783_() != null && item1.m_41783_().m_128441_("Bing")) {
                        player.m_36356_(item1);
                        item.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onM(ItemStackedOnOtherEvent event) {
            if (event.getCarriedItem().m_41783_() != null && event.getCarriedItem().m_41783_().m_128441_("Bind")) {
                event.setCanceled(true);
            }
            if (event.getSlot().m_7993_().m_41783_() != null && event.getSlot().m_7993_().m_41783_().m_128441_("Bind")) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void playerTick(TickEvent.PlayerTickEvent e) {
            Player player = e.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(CareerWarModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                Map<String, Integer> s = capability.playercooldown;
                for (Map.Entry<String, Integer> entry : s.entrySet()) {
                    CareerSkill skill;
                    String key = entry.getKey();
                    Integer value = entry.getValue();
                    if (value <= 0 || (skill = SkillHandle.getSkill(key)) != null && skill.isSelfCooldown) continue;
                    s.put(key, value - 1);
                }
                capability.playercooldown = s;
                capability.syncPlayerVariables((Entity)player);
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }
    }
}

