/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;

public class JsonCreator {
    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<ResourceLocation> items, ArrayList<String> type, ArrayList<String> pattern, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(pattern.get(0));
        jsonArray.add(pattern.get(1));
        jsonArray.add(pattern.get(2));
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject key = new JsonObject();
            key.addProperty(type.get(i), items.get(i).toString());
            keyList.add(String.valueOf(keys.get(i)), (JsonElement)key);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)1);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createSmithingRecipeJson(String baseType, ResourceLocation baseIdentifier, String additionType, ResourceLocation additionIdentifier, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smithing");
        JsonObject baseJson = new JsonObject();
        baseJson.addProperty(baseType, baseIdentifier.toString());
        json.add("base", (JsonElement)baseJson);
        JsonObject additionJson = new JsonObject();
        additionJson.addProperty(additionType, additionIdentifier.toString());
        json.add("addition", (JsonElement)additionJson);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createShapelessRecipeJson(ArrayList<ArrayList<Object>> ingredients, ResourceLocation output, int outputCount) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        JsonArray jsonArray = new JsonArray();
        for (ArrayList<Object> ingredient : ingredients) {
            JsonObject object = new JsonObject();
            object.addProperty(ingredient.get(0).toString(), ingredient.get(1).toString());
            jsonArray.add((JsonElement)object);
        }
        json.add("ingredients", (JsonElement)jsonArray);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)outputCount);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createBuiltinEntityModel(String[] elements, String[] properties, double[][][] mainArray) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", "builtin/entity");
        JsonObject display = new JsonObject();
        for (int k = 0; k < elements.length; ++k) {
            JsonObject object = new JsonObject();
            for (int i = 0; i < properties.length; ++i) {
                JsonArray arr = new JsonArray();
                for (int j = 0; j < mainArray[k][i].length; ++j) {
                    arr.add((Number)mainArray[k][i][j]);
                }
                object.add(properties[i], (JsonElement)arr);
            }
            display.add(elements[k], (JsonElement)object);
        }
        json.add("display", (JsonElement)display);
        return json;
    }

    public static JsonObject createSmeltingRecipeJson(String ingredientType, ResourceLocation ingredientId, ResourceLocation output, double expirience, int cookingtime) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smelting");
        JsonObject ingredientJson = new JsonObject();
        ingredientJson.addProperty(ingredientType, ingredientId.toString());
        json.add("ingredient", (JsonElement)ingredientJson);
        json.addProperty("result", output.toString());
        json.addProperty("expirience", (Number)expirience);
        json.addProperty("cookingtime", (Number)cookingtime);
        return json;
    }

    public static JsonObject createRecipeBookAdvancement(ResourceLocation recipeIdentifier, ResourceLocation triggerItem, boolean isItemTag) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", "recipes/root");
        JsonObject additionJson = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(recipeIdentifier.toString());
        additionJson.add("recipes", (JsonElement)jsonArray);
        json.add("rewards", (JsonElement)additionJson);
        JsonObject conditions = new JsonObject();
        if (isItemTag) {
            conditions.addProperty("tag", triggerItem.toString());
        } else {
            JsonArray items = new JsonArray();
            JsonArray item = new JsonArray();
            item.add(triggerItem.toString());
            JsonObject itemObject = new JsonObject();
            itemObject.add("items", (JsonElement)item);
            items.add((JsonElement)itemObject);
            conditions.add("items", (JsonElement)items);
        }
        JsonObject hasItem = new JsonObject();
        hasItem.addProperty("trigger", "inventory_changed");
        hasItem.add("conditions", (JsonElement)conditions);
        JsonObject hasRecipeAlready = new JsonObject();
        hasRecipeAlready.addProperty("trigger", "minecraft:recipe_unlocked");
        JsonObject condition = new JsonObject();
        condition.addProperty("recipe", recipeIdentifier.toString());
        hasRecipeAlready.add("conditions", (JsonElement)condition);
        JsonObject overallCriteria = new JsonObject();
        overallCriteria.add("has_item", (JsonElement)hasItem);
        overallCriteria.add("has_recipe", (JsonElement)hasRecipeAlready);
        json.add("criteria", (JsonElement)overallCriteria);
        JsonArray requirements = new JsonArray();
        JsonArray list = new JsonArray();
        list.add("has_item");
        list.add("has_recipe");
        requirements.add((JsonElement)list);
        json.add("requirements", (JsonElement)requirements);
        return json;
    }
}

