/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.SoulsWeaponry;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.BossCompass;
import net.soulsweaponry.items.ChaosOrb;
import net.soulsweaponry.items.LoreItem;
import net.soulsweaponry.items.ModTools;
import net.soulsweaponry.items.MoonstoneRing;
import net.soulsweaponry.items.SkofnungStone;
import net.soulsweaponry.items.armor.ChaosSet;
import net.soulsweaponry.items.armor.WitheredArmor;
import net.soulsweaponry.items.material.ModArmorMaterials;
import net.soulsweaponry.items.material.ModToolMaterials;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.RecipeHandler;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"soulsweapons");
    public static final RegistryObject<LoreItem> LORD_SOUL_RED = ITEMS.register("lord_soul_red", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_red", 4));
    public static final RegistryObject<LoreItem> LORD_SOUL_DARK = ItemRegistry.registerItem("lord_soul_dark", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_dark", 3));
    public static final RegistryObject<LoreItem> LORD_SOUL_VOID = ItemRegistry.registerItem("lord_soul_void", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_void", 3));
    public static final RegistryObject<LoreItem> LORD_SOUL_ROSE = ItemRegistry.registerItem("lord_soul_rose", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_rose", 3));
    public static final RegistryObject<LoreItem> LORD_SOUL_PURPLE = ItemRegistry.registerItem("lord_soul_purple", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_purple", 3));
    public static final RegistryObject<LoreItem> LORD_SOUL_WHITE = ItemRegistry.registerItem("lord_soul_white", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_white", 3));
    public static final RegistryObject<LoreItem> LORD_SOUL_DAY_STALKER = ItemRegistry.registerItem("lord_soul_day_stalker", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_day_stalker", 2));
    public static final RegistryObject<LoreItem> LORD_SOUL_NIGHT_PROWLER = ItemRegistry.registerItem("lord_soul_night_prowler", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_(), "lord_soul_night_prowler", 3));
    public static final RegistryObject<Item> LOST_SOUL = ItemRegistry.registerItem("lost_soul", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE), "lost_soul", 3));
    public static final RegistryObject<Item> MOONSTONE = ItemRegistry.registerItem("moonstone", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> CHUNGUS_EMERALD = ItemRegistry.registerItem("chungus_emerald", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> DEMON_HEART = ItemRegistry.registerItem("demon_heart", () -> new LoreItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(6.0f).m_38757_().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19600_, 150, 0), 1.0f).effect(() -> new MobEffectInstance((MobEffect)EffectRegistry.BLOODTHIRSTY.get(), 150, 0), 10.0f).effect(() -> new MobEffectInstance(MobEffects.f_19604_, 400, 0), 1.0f).m_38767_()), "demon_heart", 3));
    public static final RegistryObject<Item> MOLTEN_DEMON_HEART = ItemRegistry.registerItem("molten_demon_heart", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> DEMON_CHUNK = ItemRegistry.registerItem("demon_chunk", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> CRIMSON_INGOT = ItemRegistry.registerItem("crimson_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SOUL_INGOT = ItemRegistry.registerItem("soul_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SILVER_BULLET = ItemRegistry.registerGunItem("silver_bullet", () -> new Item(new Item.Properties().m_41487_(20)));
    public static final RegistryObject<Item> BOSS_COMPASS = ItemRegistry.registerItem("boss_compass", () -> new BossCompass(new Item.Properties().m_41497_(Rarity.RARE)));
    public static final RegistryObject<Item> MOONSTONE_RING = ItemRegistry.registerItem("moonstone_ring", () -> new MoonstoneRing(new Item.Properties().m_41497_(Rarity.EPIC).m_41503_(25)));
    public static final RegistryObject<Item> SHARD_OF_UNCERTAINTY = ItemRegistry.registerItem("shard_of_uncertainty", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_(), "shard_of_uncertainty", 1));
    public static final RegistryObject<Item> VERGLAS = ItemRegistry.registerItem("verglas", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SKOFNUNG_STONE = ItemRegistry.registerItem("skofnung_stone", () -> new SkofnungStone(new Item.Properties().m_41503_(20)));
    public static final RegistryObject<Item> IRON_SKULL = ItemRegistry.registerItem("iron_skull", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> MOONSTONE_SHOVEL = ItemRegistry.registerItem("moonstone_shovel", () -> new ShovelItem((Tier)ModToolMaterials.MOONSTONE_TOOL, 1.5f, -3.0f, new Item.Properties()));
    public static final RegistryObject<Item> MOONSTONE_PICKAXE = ItemRegistry.registerItem("moonstone_pickaxe", () -> new ModTools.ModPickaxe(ModToolMaterials.MOONSTONE_TOOL, 1, -2.8f, new Item.Properties()));
    public static final RegistryObject<Item> MOONSTONE_AXE = ItemRegistry.registerItem("moonstone_axe", () -> new ModTools.ModAxe(ModToolMaterials.MOONSTONE_TOOL, 5, -3.0f, new Item.Properties()));
    public static final RegistryObject<Item> MOONSTONE_HOE = ItemRegistry.registerItem("moonstone_hoe", () -> new ModTools.ModHoe(ModToolMaterials.MOONSTONE_TOOL, -3, 0.0f, new Item.Properties()));
    public static final RegistryObject<LoreItem> WITHERED_DEMON_HEART = ItemRegistry.registerItem("withered_demon_heart", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_(), "withered_demon_heart", 4));
    public static final RegistryObject<LoreItem> ARKENSTONE = ItemRegistry.registerItem("arkenstone", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_(), "arkenstone", 4));
    public static final RegistryObject<LoreItem> ESSENCE_OF_EVENTIDE = ItemRegistry.registerItem("essence_of_eventide", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_(), "essence_of_eventide", 2));
    public static final RegistryObject<LoreItem> ESSENCE_OF_LUMINESCENCE = ItemRegistry.registerItem("essence_of_luminescence", () -> new LoreItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_(), "essence_of_luminescence", 3));
    public static final RegistryObject<Item> CHAOS_CROWN = ItemRegistry.registerItem("chaos_crown", () -> new ChaosSet(ModArmorMaterials.CHAOS_SET, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(Rarity.EPIC)));
    public static final RegistryObject<Item> CHAOS_HELMET = ItemRegistry.registerArmorItem("chaos_helmet", () -> new ChaosSet(ModArmorMaterials.CHAOS_ARMOR, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(Rarity.EPIC)), ConfigConstructor.disable_recipe_chaos_helmet);
    public static final RegistryObject<Item> ARKENPLATE = ItemRegistry.registerArmorItem("arkenplate", () -> new ChaosSet(ModArmorMaterials.CHAOS_ARMOR, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.EPIC)), ConfigConstructor.disable_recipe_arkenplate);
    public static final RegistryObject<Item> ENHANCED_ARKENPLATE = ItemRegistry.registerArmorItem("enhanced_arkenplate", () -> new ChaosSet(ModArmorMaterials.CHAOS_ARMOR, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.EPIC)), ConfigConstructor.disable_recipe_enhanced_arkenplate);
    public static final RegistryObject<Item> WITHERED_CHEST = ItemRegistry.registerArmorItem("withered_chest", () -> new WitheredArmor(ModArmorMaterials.CHAOS_ARMOR, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.EPIC)), ConfigConstructor.disable_recipe_withered_chest);
    public static final RegistryObject<Item> ENHANCED_WITHERED_CHEST = ItemRegistry.registerArmorItem("enhanced_withered_chest", () -> new WitheredArmor(ModArmorMaterials.WITHERED_ARMOR, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.EPIC)), ConfigConstructor.disable_recipe_enhanced_withered_chest);
    public static final RegistryObject<Item> CHAOS_ROBES = ItemRegistry.registerItem("chaos_robes", () -> new ChaosSet(ModArmorMaterials.CHAOS_SET, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.EPIC)));
    public static final RegistryObject<Item> CHAOS_ORB = ItemRegistry.registerItem("chaos_orb", () -> new ChaosOrb(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_()));
    public static final RegistryObject<RecordItem> CHUNGUS_DISC = ItemRegistry.registerItem("chungus_disc", () -> new RecordItem(7, SoundRegistry.BIG_CHUNGUS_SONG_EVENT, new Item.Properties().m_41487_(1), 2240));

    public static <I extends Item> RegistryObject<I> registerItem(String id, Supplier<I> item) {
        RegistryObject registered = ITEMS.register(id, item);
        SoulsWeaponry.ITEM_GROUP_LIST.add((RegistryObject<? extends Item>)registered);
        return registered;
    }

    public static <I extends Item> RegistryObject<I> registerItemRemovableRecipe(String name, Supplier<I> item, boolean removeRecipe) {
        RecipeHandler.RECIPE_IDS.put(new ResourceLocation("soulsweapons", name), removeRecipe);
        return ItemRegistry.registerItem(name, item);
    }

    public static <I extends Item> RegistryObject<I> registerArmorItem(String name, Supplier<I> item, boolean removeRecipe) {
        if (ConfigConstructor.disable_armor_recipes) {
            return ItemRegistry.registerItemRemovableRecipe(name, item, true);
        }
        return ItemRegistry.registerItemRemovableRecipe(name, item, removeRecipe);
    }

    public static <I extends Item> RegistryObject<I> registerWeaponItem(String name, Supplier<I> item, boolean removeRecipe) {
        if (ConfigConstructor.disable_weapon_recipes) {
            return ItemRegistry.registerItemRemovableRecipe(name, item, true);
        }
        return ItemRegistry.registerItemRemovableRecipe(name, item, removeRecipe);
    }

    public static <I extends Item> RegistryObject<I> registerGunItem(String name, Supplier<I> item) {
        return ItemRegistry.registerItemRemovableRecipe(name, item, ConfigConstructor.disable_gun_recipes);
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

