/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.armor.WitheredArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WitheredArmor
extends ModdedArmor
implements GeoItem,
IKeybindAbility,
ICooldownItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WitheredArmor(ArmorMaterial material, ArmorItem.Type slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player && this.isChestActive(player = (Player)entity)) {
            if (player.m_21223_() < player.m_21233_() / 2.0f && player.m_21023_(MobEffects.f_19615_)) {
                player.m_21195_(MobEffects.f_19615_);
            }
            if (this.isChestEnhanced(player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0));
                if (player.m_6060_() && player.f_19797_ % 30 == 0) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0));
                }
                if (player.m_21223_() < player.m_21233_() * ConfigConstructor.withered_chest_strength_trigger_percent_1) {
                    if (player.m_21223_() < player.m_21233_() * ConfigConstructor.withered_chest_strength_trigger_percent_2) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 1));
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 0));
                    }
                }
            }
        }
    }

    private boolean isChestActive(Player player) {
        ItemStack chest = player.m_150109_().m_36052_(2);
        return !chest.m_41619_() && !this.isDisabled(chest) && (chest.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) || chest.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get()));
    }

    private boolean isChestEnhanced(Player player) {
        ItemStack chest = player.m_150109_().m_36052_(2);
        return !chest.m_41619_() && !this.isDisabled(chest) && chest.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get());
    }

    private PlayState souls(AnimationState<?> event) {
        if (this.equals(ItemRegistry.ENHANCED_WITHERED_CHEST.get())) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("soul_spin"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("no_souls"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState heart(AnimationState<?> event) {
        if (this.equals(ItemRegistry.ENHANCED_WITHERED_CHEST.get())) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("idle_heartbeat"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "souls", 0, this::souls)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "heart", 0, this::heart)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.LIFE_LEACH.get(), ConfigConstructor.withered_chest_life_leach_duration, ConfigConstructor.withered_chest_life_leach_amplifier));
            player.m_36335_().m_41524_(stack.m_41720_(), Math.max(ConfigConstructor.withered_chest_ability_min_cooldown, ConfigConstructor.withered_chest_ability_cooldown - this.getReduceCooldownEnchantLevel(stack) * 60));
            world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.DEMON_BOSS_IDLE_EVENT.get(), SoundSource.PLAYERS, 0.75f, 1.0f);
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        if (Screen.m_96638_()) {
            if (stack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get())) {
                int i;
                boolean bl = stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get());
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.unceasing").m_130940_(ChatFormatting.DARK_PURPLE));
                for (i = 1; i <= 4; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.withered_armor.unceasing." + i)).m_130940_(ChatFormatting.GRAY));
                }
                WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.2").m_130940_(ChatFormatting.GRAY));
                if (bl) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.3").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.fire_immune").m_130940_(ChatFormatting.GOLD));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.fire_immune.1").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt").m_130940_(ChatFormatting.RED));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.1").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.2").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.3").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.4").m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (Screen.m_96637_()) {
                    if (bl) {
                        for (i = 1; i <= 3; ++i) {
                            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.withered_chest.lore.enhanced." + i)).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    } else {
                        for (i = 1; i <= 4; ++i) {
                            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.withered_chest.lore." + i)).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    }
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.control"));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_withered_set;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null && (itemStack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) || itemStack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get()))) {
                    this.renderer = new WitheredArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_withered_chest;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return (stack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get())) && ConfigConstructor.withered_chest_ability_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        if (stack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get())) {
            return ConfigConstructor.withered_chest_ability_enchant_reduces_cooldown_id;
        }
        return null;
    }
}

