/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.blocks.WitheredBlock;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredGrass;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.blocks.WitheredTallGrass;
import net.soulsweaponry.client.renderer.armor.ChaosArmorRenderer;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.client.renderer.armor.EChaosArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosSet
extends ModdedArmor
implements GeoItem,
ICooldownItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final HashMap<Block, WitheredBlock> turnableBlocks = new HashMap();
    private final HashMap<Block, WitheredGrass> turnableGrass = new HashMap();
    private final HashMap<Block, WitheredTallGrass> turnableTallPlant = new HashMap();
    private static final HashMap<MobEffect, MobEffect> FLIPPABLE_EFFECTS = new HashMap();

    public ChaosSet(ArmorMaterial material, ArmorItem.Type slot, Item.Properties settings) {
        super(material, slot, settings);
        this.turnableBlocks.put(Blocks.f_50440_, (WitheredBlock)((Object)BlockRegistry.WITHERED_GRASS_BLOCK.get()));
        this.turnableBlocks.put(Blocks.f_50493_, (WitheredBlock)((Object)BlockRegistry.WITHERED_DIRT.get()));
        this.turnableGrass.put(Blocks.f_50034_, (WitheredGrass)BlockRegistry.WITHERED_GRASS.get());
        this.turnableGrass.put(Blocks.f_50035_, (WitheredGrass)BlockRegistry.WITHERED_FERN.get());
        this.turnableGrass.put(Blocks.f_50685_, (WitheredGrass)BlockRegistry.WITHERED_BERRY_BUSH.get());
        this.turnableTallPlant.put(Blocks.f_50359_, (WitheredTallGrass)BlockRegistry.WITHERED_TALL_GRASS.get());
        this.turnableTallPlant.put(Blocks.f_50360_, (WitheredTallGrass)BlockRegistry.WITHERED_LARGE_FERN.get());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isHelmetEquipped(player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 40, 0));
                if (!player.m_36335_().m_41519_((Item)ItemRegistry.CHAOS_CROWN.get()) && !player.m_36335_().m_41519_((Item)ItemRegistry.CHAOS_HELMET.get())) {
                    this.flipEffects(player);
                }
            }
            if (this.isRobesEquipped(player)) {
                this.turnBlocks((LivingEntity)player, world, player.m_20183_(), 0);
                if (player.f_19797_ % 40 == 0) {
                    for (LivingEntity target : world.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(3.0))) {
                        if (target instanceof Player || target == player) continue;
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1));
                    }
                }
            }
            if (this.isChestActive(player)) {
                ItemStack chest = player.m_150109_().m_36052_(2);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 1));
                if (!world.f_46443_ && !player.m_36335_().m_41519_(chest.m_41720_()) && player.m_21188_() != null) {
                    this.shockwave(world, player);
                }
            }
        }
    }

    public void turnBlocks(LivingEntity entity, Level world, BlockPos blockPos, int bonusRadius) {
        if (!entity.m_20096_()) {
            return;
        }
        int f = Math.min(16, 3 + bonusRadius);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos2 : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-f, -1, -f), (BlockPos)blockPos.m_7918_(f, -1, f))) {
            if (world.m_8055_(blockPos2).m_60795_()) continue;
            for (Block turnBlock : this.turnableBlocks.keySet()) {
                if (world.m_8055_(blockPos2).m_60734_() == turnBlock) {
                    BlockState blockState = this.turnableBlocks.get(turnBlock).m_49966_();
                    if (!blockPos2.m_203195_((Position)entity.m_20182_(), (double)f)) continue;
                    mutable.m_122178_(blockPos2.m_123341_(), blockPos2.m_123342_() + 1, blockPos2.m_123343_());
                    BlockState blockState2 = world.m_8055_((BlockPos)mutable);
                    if (blockState2.m_204336_(BlockTags.f_13037_)) {
                        world.m_46597_((BlockPos)mutable, (BlockState)((WitheredFlower)BlockRegistry.HYDRANGEA.get()).m_49966_().m_61124_((Property)WitheredFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false)));
                    }
                    for (Block turnGrass : this.turnableGrass.keySet()) {
                        if (!blockState2.m_60713_(turnGrass)) continue;
                        world.m_46597_((BlockPos)mutable, this.turnableGrass.get(turnGrass).m_49966_());
                    }
                    for (Block turnTallPlant : this.turnableTallPlant.keySet()) {
                        if (!blockState2.m_60713_(turnTallPlant)) continue;
                        world.m_7471_((BlockPos)mutable, false);
                        DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)this.turnableTallPlant.get(turnTallPlant).m_49966_(), (BlockPos)mutable, (int)2);
                    }
                    if (blockState2.m_204336_(BlockTags.f_13040_)) {
                        world.m_7471_((BlockPos)mutable, false);
                        DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)((BlockState)((WitheredTallFlower)BlockRegistry.OLEANDER.get()).m_49966_().m_61124_((Property)WitheredTallFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false))), (BlockPos)mutable, (int)2);
                    }
                    world.m_46597_(blockPos2, blockState);
                    world.m_186460_(blockPos2, (Block)this.turnableBlocks.get(turnBlock), Mth.m_216271_((RandomSource)entity.m_217043_(), (int)50, (int)90));
                    continue;
                }
                if (world.m_8055_(blockPos2).m_60734_() != this.turnableBlocks.get(turnBlock)) continue;
                WitheredBlock block = (WitheredBlock)world.m_8055_(blockPos2).m_60734_();
                block.resetAge(world.m_8055_(blockPos2), world, blockPos2);
            }
        }
    }

    private void flipEffects(Player player) {
        ArrayList statusEffectsCopy = new ArrayList(player.m_21220_());
        ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
        boolean triggered = false;
        for (MobEffectInstance instance : statusEffectsCopy) {
            MobEffect effect = instance.m_19544_();
            if (effect.m_19483_() != MobEffectCategory.HARMFUL) continue;
            int duration = (int)((float)instance.m_19557_() / 3.0f);
            int amplifier = (int)((float)instance.m_19564_() / 2.0f);
            MobEffect newEffect = MobEffects.f_19605_;
            for (MobEffect harmful : FLIPPABLE_EFFECTS.keySet()) {
                if (!effect.equals(harmful)) continue;
                newEffect = FLIPPABLE_EFFECTS.get(harmful);
                break;
            }
            effectsToRemove.add(effect);
            triggered = true;
            player.m_7292_(new MobEffectInstance(newEffect, duration, amplifier));
        }
        for (MobEffect effectToRemove : effectsToRemove) {
            player.m_21195_(effectToRemove);
        }
        if (triggered && !player.m_7500_()) {
            player.m_36335_().m_41524_((Item)ItemRegistry.CHAOS_CROWN.get(), Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - this.getReduceCooldownEnchantLevel(player.m_6844_(EquipmentSlot.HEAD)) * 40));
            player.m_36335_().m_41524_((Item)ItemRegistry.CHAOS_HELMET.get(), Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - this.getReduceCooldownEnchantLevel(player.m_6844_(EquipmentSlot.HEAD)) * 40));
        }
    }

    private void shockwave(Level world, Player player) {
        float i = ConfigConstructor.arkenplate_shockwave_knockback;
        ItemStack stack = player.m_150109_().m_36052_(2);
        if (stack == null) {
            return;
        }
        i += (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        if (!world.f_46443_) {
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123812_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (Entity entity : world.m_45933_((Entity)player, player.m_20191_().m_82400_(5.0))) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).m_7307_((Entity)player)) continue;
            if (this.equals(ItemRegistry.ENHANCED_ARKENPLATE)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 160, 2));
            }
            target.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), ConfigConstructor.arkenplate_shockwave_damage);
            double x = player.m_20185_() - target.m_20185_();
            double z = player.m_20189_() - target.m_20189_();
            target.m_147240_((double)(i * 0.5f), x, z);
        }
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), Math.max(ConfigConstructor.arkenplate_shockwave_min_cooldown, ConfigConstructor.arkenplate_shockwave_cooldown - this.getReduceCooldownEnchantLevel(stack) * 20));
        }
    }

    private boolean isHelmetEquipped(Player player) {
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !this.isDisabled(helmet) && (helmet.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) || helmet.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get()));
    }

    private boolean isRobesEquipped(Player player) {
        ItemStack chest = player.m_150109_().m_36052_(2);
        return !chest.m_41619_() && !this.isDisabled(chest) && chest.m_150930_((Item)ItemRegistry.CHAOS_ROBES.get());
    }

    private boolean isChestActive(Player player) {
        ItemStack chest = player.m_150109_().m_36052_(2);
        return !chest.m_41619_() && !this.isDisabled(chest) && (chest.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) || chest.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) && player.m_21223_() < player.m_21233_() / 2.0f;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this == ItemRegistry.CHAOS_ROBES.get()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        if (this.equals(ItemRegistry.ENHANCED_ARKENPLATE.get())) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("soul_spin"));
        } else if (this.equals(ItemRegistry.ARKENPLATE.get())) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("no_souls"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        if (Screen.m_96638_()) {
            if (stack.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) || stack.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_4").m_130940_(ChatFormatting.DARK_GRAY));
                if (stack.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get())) {
                    if (Screen.m_96637_()) {
                        for (int i = 1; i <= 4; ++i) {
                            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.chaos_crown_lore_" + i)).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    } else {
                        tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.control"));
                    }
                } else if (Screen.m_96637_()) {
                    for (int i = 1; i <= 4; ++i) {
                        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.chaos_helm_lore_" + i)).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.control"));
                }
            } else if (stack.m_150930_((Item)ItemRegistry.CHAOS_ROBES.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_4").m_130940_(ChatFormatting.GRAY));
                if (Screen.m_96637_()) {
                    for (int i = 1; i <= 4; ++i) {
                        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.chaos_robes_lore_" + i)).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.control"));
                }
            } else if (stack.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock").m_130940_(ChatFormatting.DARK_GREEN));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.3").m_130940_(ChatFormatting.GRAY));
                if (stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.4").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror").m_130940_(ChatFormatting.DARK_PURPLE));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror.1").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)((int)(ConfigConstructor.arkenplate_mirror_trigger_percent * 100.0f) + "%")).m_130940_(ChatFormatting.RED)));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror.2").m_130940_(ChatFormatting.GRAY));
                }
                if (!stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) {
                    if (Screen.m_96637_()) {
                        for (int i = 1; i <= 4; ++i) {
                            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.arkenplate_lore_" + i)).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    } else {
                        tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.control"));
                    }
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_chaos_set;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = itemStack.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get()) || itemStack.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) ? new ChaosArmorRenderer() : (itemStack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get()) ? new EChaosArmorRenderer() : new ChaosSetRenderer());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        if (stack.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) || stack.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get())) {
            return ConfigConstructor.disable_use_chaos_crown;
        }
        if (stack.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) {
            return ConfigConstructor.disable_use_arkenplate;
        }
        if (stack.m_150930_((Item)ItemRegistry.CHAOS_ROBES.get())) {
            return ConfigConstructor.disable_use_chaos_robes;
        }
        return false;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return (stack.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) || stack.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get())) && ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown || (stack.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) && ConfigConstructor.arkenplate_shockwave_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        if (stack.m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) || stack.m_150930_((Item)ItemRegistry.CHAOS_HELMET.get())) {
            return ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown_id;
        }
        if (stack.m_150930_((Item)ItemRegistry.ARKENPLATE.get()) || stack.m_150930_((Item)ItemRegistry.ENHANCED_ARKENPLATE.get())) {
            return ConfigConstructor.arkenplate_shockwave_enchant_reduces_cooldown_id;
        }
        return null;
    }

    static {
        FLIPPABLE_EFFECTS.put(MobEffects.f_19597_, MobEffects.f_19596_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19599_, MobEffects.f_19598_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19613_, MobEffects.f_19600_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19610_, MobEffects.f_19611_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19612_, MobEffects.f_19618_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19620_, MobEffects.f_19591_);
    }
}

