/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.WitheredWabbajackProjectile;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.WeaponUtil;

public class WitheredWabbajack
extends ModdedSword {
    public WitheredWabbajack(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.withered_wabbajack_damage, ConfigConstructor.withered_wabbajack_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.WABBAJACK, WeaponUtil.TooltipAbilities.LUCK_BASED);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_36335_().m_41524_((Item)this, 1);
        world.m_6263_(user, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11896_, SoundSource.NEUTRAL, 0.5f, 2.0f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            Vec3 look = user.m_20154_();
            Projectile entity = this.calculateProjectile((LivingEntity)user, world, look, itemStack);
            if (entity instanceof DragonStaffProjectile) {
                DragonStaffProjectile dragonStaffProjectile = (DragonStaffProjectile)entity;
                dragonStaffProjectile.setRadius(2.0f + user.m_217043_().m_188501_() * (float)this.getLuckFactor((LivingEntity)user));
            }
            entity.m_20343_(user.m_20185_(), user.m_20188_(), user.m_20189_());
            if (entity instanceof GrowingFireball) {
                GrowingFireball ball = (GrowingFireball)entity;
                float power = 1.0f + user.m_217043_().m_188501_() * 10.0f * (float)this.getLuckFactor((LivingEntity)user);
                int duration = user.m_217043_().m_216332_(10, 100 + 20 * this.getLuckFactor((LivingEntity)user));
                float speed = (float)user.m_217043_().m_216332_(25, 300 + 20 * this.getLuckFactor((LivingEntity)user)) / 100.0f;
                ball.setMaxAge(duration);
                ball.setRadiusGrowth(power / (float)duration);
                ball.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, speed, 0.0f);
            } else {
                entity.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f, 0.0f);
            }
            world.m_7967_((Entity)entity);
            itemStack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(hand));
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
    }

    /*
     * WARNING - void declaration
     */
    private Projectile calculateProjectile(LivingEntity user, Level world, Vec3 look, ItemStack stack) {
        void var10_14;
        int power = new Random().nextInt(6 + this.getLuckFactor(user) - this.getLuckFactor(user)) + this.getLuckFactor(user);
        Object[][] projectileTypes = new Object[][]{{new Arrow(world, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new DragonStaffProjectile(world, user, stack), LuckType.NEUTRAL}, {new ThrownEgg(world, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new ThrownEnderpearl(world, user), LuckType.BAD}, {new ThrownExperienceBottle(world, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new LargeFireball(world, user, look.m_7096_(), look.m_7098_(), look.m_7094_(), power), LuckType.NEUTRAL}, {new SmallFireball(world, user, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new Snowball(world, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new WitherSkull(world, user, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.BAD}, {new WitheredWabbajackProjectile(world, user, look.m_7096_(), look.m_7098_(), look.m_7094_()), LuckType.GOOD}, {new GrowingFireball(world, (Entity)user), LuckType.NEUTRAL}};
        ArrayList projectileList = new ArrayList();
        Object[][] objectArrayArray = projectileTypes;
        int n = objectArrayArray.length;
        boolean bl = false;
        while (var10_14 < n) {
            int luckFactor;
            Object[] projectileType = objectArrayArray[var10_14];
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(projectileType[0]);
            list.add(projectileType[1]);
            switch (((LuckType)((Object)list.get(1))).ordinal()) {
                case 2: {
                    luckFactor = 10 - this.getLuckFactor(user);
                    list.add(luckFactor);
                    break;
                }
                case 0: {
                    luckFactor = 10 + this.getLuckFactor(user);
                    list.add(luckFactor);
                    break;
                }
                default: {
                    luckFactor = 10;
                    list.add(luckFactor);
                }
            }
            if (luckFactor > 0) {
                projectileList.add(list);
            }
            ++var10_14;
        }
        int totalChance = 0;
        for (ArrayList arrayList : projectileList) {
            totalChance += ((Integer)arrayList.get(2)).intValue();
        }
        int random = new Random().nextInt(totalChance);
        boolean bl2 = false;
        int under = 0;
        Projectile chosenProjectile = null;
        for (int i = 0; i < projectileList.size(); ++i) {
            void var10_17;
            var10_17 += ((Integer)((ArrayList)projectileList.get(i)).get(2)).intValue();
            if (i > 0) {
                under += ((Integer)((ArrayList)projectileList.get(i - 1)).get(2)).intValue();
            }
            if (random >= var10_17 || random < under) continue;
            chosenProjectile = (Projectile)((ArrayList)projectileList.get(i)).get(0);
        }
        return chosenProjectile;
    }

    public int getLuckFactor(LivingEntity entity) {
        if (entity.m_21023_(MobEffects.f_19621_)) {
            return entity.m_21124_(MobEffects.f_19621_).m_19564_() * 2 + 2;
        }
        if (entity.m_21023_(MobEffects.f_19590_)) {
            return -(entity.m_21124_(MobEffects.f_19590_).m_19564_() * 2 + 2);
        }
        return 0;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_withered_wabbajack;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_withered_wabbajack;
    }

    public static enum LuckType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

