/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class WhirligigSawblade
extends ChargeToUseItem {
    public WhirligigSawblade(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.whirligig_sawblade_damage, ConfigConstructor.whirligig_sawblade_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.SAWBLADE);
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public int m_8105_(ItemStack stack) {
        return ConfigConstructor.whirligig_sawblade_use_time + WeaponUtil.getEnchantDamageBonus(stack) * 10;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        Vec3 vecBlocksAway = user.m_20154_().m_82490_(5.0).m_82549_(user.m_20182_());
        AABB chunkBox = new AABB(user.m_20185_(), user.m_20186_(), user.m_20189_(), vecBlocksAway.f_82479_, vecBlocksAway.f_82480_ + 1.0, vecBlocksAway.f_82481_);
        List nearbyEntities = world.m_45933_((Entity)user, chunkBox);
        if (remainingUseTicks > 0) {
            for (Entity nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)nearbyEntity;
                if (target.m_6469_(world.m_269111_().m_269333_(user), ConfigConstructor.whirligig_sawblade_ability_damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()))) {
                    world.m_5594_(null, user.m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    target.m_147240_(1.0, 0.0, 0.0);
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEED.get(), 100, 0));
                }
                world.m_6493_((ParticleOptions)ParticleTypes.f_123766_, true, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), (double)(target.m_217043_().m_188503_(10) - 5), (double)(target.m_217043_().m_188503_(10) - 5), (double)(target.m_217043_().m_188503_(10) - 5));
            }
        } else {
            user.m_21253_();
            super.m_5929_(world, user, stack, remainingUseTicks);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        this.stop(user, stack);
        return super.m_5922_(stack, world, user);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.stop(user, stack);
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.whirligig_sawblade_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.whirligig_sawblade_enchant_reduces_cooldown_id;
    }

    private void stop(LivingEntity user, ItemStack stack) {
        if (user instanceof Player) {
            Player player = (Player)user;
            this.applyItemCooldown(player, this.getCooldown(stack));
        }
        stack.m_41622_(3, user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
    }

    private int getCooldown(ItemStack stack) {
        return Math.max(ConfigConstructor.whirligig_sawblade_min_cooldown, ConfigConstructor.whirligig_sawblade_cooldown - this.getReduceCooldownEnchantLevel(stack) * 10);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_whirligig_sawblade;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_whirligig_sawblade;
    }
}

