/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public abstract class ModdedAxe
extends AxeItem
implements IConfigDisable,
ICooldownItem {
    protected final List<WeaponUtil.TooltipAbilities> tooltipAbilities = new ArrayList<WeaponUtil.TooltipAbilities>();

    public ModdedAxe(Tier material, float attackDamage, float ingameAttackSpeed, Item.Properties settings) {
        super(material, attackDamage, -(4.0f - ingameAttackSpeed), settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        boolean epicFight;
        boolean showInfo;
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        boolean bl = showInfo = !(epicFight = WeaponUtil.isModLoaded("epicfight")) ? Screen.m_96638_() : Screen.m_96639_();
        if (showInfo) {
            for (WeaponUtil.TooltipAbilities ability : this.getTooltipAbilities()) {
                WeaponUtil.addAbilityTooltip(ability, stack, tooltip);
            }
            tooltip.addAll(Arrays.asList(this.getAdditionalTooltips()));
        } else if (epicFight) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.alt"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public List<WeaponUtil.TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    public void addTooltipAbility(WeaponUtil.TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    public abstract boolean m_41475_();

    public int getChargeTime(ItemStack stack, int remainingUseTicks) {
        int i = WeaponUtil.isModLoaded("epicfight") ? Integer.MAX_VALUE - remainingUseTicks : this.m_8105_(stack) - remainingUseTicks;
        return i;
    }
}

