/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.LeviathanAxeRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.LeviathanAxeEntity;
import net.soulsweaponry.items.ModdedAxe;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeviathanAxe
extends ModdedAxe
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public LeviathanAxe(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.leviathan_axe_damage, ConfigConstructor.leviathan_axe_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.FREEZE, WeaponUtil.TooltipAbilities.PERMAFROST, WeaponUtil.TooltipAbilities.HEAVY_THROW, WeaponUtil.TooltipAbilities.RETURNING);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_leviathan_axe;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        int sharpness = Mth.m_14143_((float)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()));
        target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 200, sharpness));
        return super.m_7579_(stack, target, attacker);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        super.m_5551_(stack, world, user, remainingUseTicks);
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.m_41622_(3, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                if (stack.m_41782_()) {
                    stack.m_41783_().m_128385_("owners_last_pos", new int[]{playerEntity.m_146903_(), playerEntity.m_146904_(), playerEntity.m_146907_()});
                }
                LeviathanAxeEntity entity = new LeviathanAxeEntity(world, user, stack);
                entity.saveOnPlayer(playerEntity);
                float speed = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack) / 5.0f;
                entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.5f + speed, 1.0f);
                entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                world.m_7967_((Entity)entity);
                world.m_5594_(playerEntity, playerEntity.m_20183_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 0.5f);
                if (!playerEntity.m_150110_().f_35937_) {
                    playerEntity.m_150109_().m_36057_(stack);
                }
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static void iceExplosion(Level world, BlockPos pos, @Nullable Entity attacker, int amplifier) {
        AABB box = new AABB(pos).m_82400_(1.0);
        List entities = world.m_45933_(attacker, box);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof Player) continue;
            livingEntity.m_6469_(world.m_269111_().m_269109_(), (float)(amplifier + 1) * 1.5f);
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 200, amplifier));
        }
        if (!world.f_46443_) {
            ParticleHandler.particleSphere(world, 300, pos.m_123341_(), (float)pos.m_123342_() + 0.5f, pos.m_123343_(), ParticleEvents.ICE_PARTICLE, 1.0f);
        }
        world.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
        world.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 0.5f);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_leviathan_axe;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private LeviathanAxeRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new LeviathanAxeRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }
}

