/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.projectile_damage.api.IProjectileWeapon;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.KrakenSlayerProjectile;
import net.soulsweaponry.items.ModdedBow;
import net.soulsweaponry.util.WeaponUtil;

public class KrakenSlayer
extends ModdedBow {
    public KrakenSlayer(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.FAST_PULL, WeaponUtil.TooltipAbilities.THIRD_SHOT);
        ((IProjectileWeapon)this).setProjectileDamage((double)ConfigConstructor.kraken_slayer_damage);
        ((IProjectileWeapon)this).setCustomLaunchVelocity(Double.valueOf(ConfigConstructor.kraken_slayer_max_velocity));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_kraken_slayer_bow;
    }

    @Override
    public AbstractArrow getModifiedProjectile(Level world, ItemStack bowStack, ItemStack arrowStack, LivingEntity shooter, AbstractArrow originalArrow) {
        if (bowStack.m_41782_() && bowStack.m_41783_().m_128441_("firedShots") && bowStack.m_41783_().m_128451_("firedShots") >= 2) {
            KrakenSlayerProjectile projectile = new KrakenSlayerProjectile(world, shooter);
            projectile.setTrueDamage(ConfigConstructor.kraken_slayer_bonus_true_damage + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack));
            bowStack.m_41783_().m_128405_("firedShots", 0);
            return projectile;
        }
        if (bowStack.m_41782_()) {
            if (bowStack.m_41783_().m_128441_("firedShots")) {
                bowStack.m_41783_().m_128405_("firedShots", bowStack.m_41783_().m_128451_("firedShots") + 1);
            } else {
                bowStack.m_41783_().m_128405_("firedShots", 1);
            }
        }
        return null;
    }

    @Override
    public int getPullTime() {
        return ConfigConstructor.kraken_slayer_pull_time_ticks;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_kraken_slayer_bow;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (WeaponUtil.isModLoaded("epicfight")) {
            return UseAnim.BOW;
        }
        for (UseAnim action : UseAnim.values()) {
            if (!action.toString().equals(ConfigConstructor.kraken_slayer_bow_use_animation)) continue;
            return action;
        }
        return UseAnim.SPEAR;
    }
}

