/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.UmbralTrespassItem;
import net.soulsweaponry.util.WeaponUtil;

public class DarkinScythePrime
extends UmbralTrespassItem {
    public DarkinScythePrime(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.darkin_scythe_damage + ConfigConstructor.darkin_scythe_bonus_damage, ConfigConstructor.darkin_scythe_prime_attack_speed, settings, ConfigConstructor.darkin_scythe_prime_ticks_before_dismount);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.OMNIVAMP);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker instanceof Player && !(player = (Player)attacker).m_36335_().m_41519_(stack.m_41720_()) && !(player.m_21223_() >= player.m_21233_())) {
            this.applyItemCooldown(player, Math.max(ConfigConstructor.lifesteal_item_min_cooldown, ConfigConstructor.lifesteal_item_cooldown - this.getReduceLifeStealCooldownEnchantLevel(stack) * 6));
            float healing = ConfigConstructor.lifesteal_item_base_healing;
            if (ConfigConstructor.lifesteal_item_heal_scales) {
                healing += (float)Mth.m_14167_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            }
            attacker.m_5634_(healing);
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_darkin_scythe_prime;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_darkin_scythe_prime;
    }

    @Override
    public float getAbilityDamage() {
        return ConfigConstructor.darkin_scythe_prime_ability_damage;
    }

    @Override
    public int getAbilityCooldown(ItemStack stack) {
        return Math.max(ConfigConstructor.darkin_scythe_prime_ability_min_cooldown, ConfigConstructor.darkin_scythe_prime_ability_cooldown - this.getReduceCooldownEnchantLevel(stack) * 25);
    }

    @Override
    public boolean shouldAbilityHeal() {
        return true;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.darkin_scythe_prime_ability_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.darkin_scythe_prime_ability_enchant_reduces_cooldown_id;
    }
}

