/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;

public class MoonlightArrow
extends AbstractArrow {
    private int maxArrowAge = 1000;

    public MoonlightArrow(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public MoonlightArrow(Level world, LivingEntity owner) {
        super((EntityType)EntityRegistry.MOONLIGHT_ARROW.get(), owner, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public void m_8119_() {
        if (!this.f_36703_) {
            Vec3 vec3d = this.m_20184_();
            double e = vec3d.f_82479_;
            double f = vec3d.f_82480_ + (double)0.2f;
            double g = vec3d.f_82481_;
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_(this.getParticleType(), this.m_20185_() + e * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0, this.m_20189_() + g * (double)i / 4.0, 0.0, 0.0, 0.0);
            }
        }
        super.m_8119_();
        if (this.f_19797_ > this.maxArrowAge) {
            this.m_146870_();
        }
    }

    public byte m_36796_() {
        return 4;
    }

    protected boolean m_142470_(Player player) {
        if (this.maxArrowAge > 100) {
            return super.m_142470_(player);
        }
        return false;
    }

    protected ParticleOptions getParticleType() {
        return (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get();
    }

    protected ItemStack m_7941_() {
        return Items.f_42412_.m_7968_();
    }

    public void setMaxArrowAge(int maxArrowAge) {
        this.maxArrowAge = maxArrowAge;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("maxArrowAge")) {
            this.maxArrowAge = nbt.m_128451_("maxArrowAge");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("maxArrowAge", this.maxArrowAge);
    }
}

