/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.BigChungus;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class ChaosSkull
extends WitherSkull {
    public ChaosSkull(EntityType<ChaosSkull> chaosSkullEntityType, Level world) {
        super(chaosSkullEntityType, world);
    }

    public ChaosSkull(double x, double y, double z, double directionX, double directionY, double directionZ, Level world) {
        super((EntityType)EntityRegistry.CHAOS_SKULL.get(), world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
        if (d != 0.0) {
            this.f_36813_ = directionX / d * 0.1;
            this.f_36814_ = directionY / d * 0.1;
            this.f_36815_ = directionZ / d * 0.1;
        }
    }

    protected float m_6884_() {
        return 1.0f;
    }

    private float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.chaos_monarch_damage_modifier;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        if (entityHitResult.m_82443_() != null && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (this.m_19749_() instanceof LivingEntity) {
                float damage;
                int rng = this.f_19796_.m_188503_(3);
                if (rng == 0) {
                    int duration = this.f_19796_.m_188503_(160) + 40;
                    int amplifier = this.f_19796_.m_188503_(3);
                    entity2.m_7292_(new MobEffectInstance(this.getPotionEffect(), duration, amplifier));
                }
                if ((damage = this.getModifiedDamage(this.f_19796_.m_188503_(30) + 1)) > this.getModifiedDamage(20.0f)) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.CRIT_HIT_EVENT.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
                }
                entity2.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this.m_19749_()), damage);
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.m_8060_(blockHitResult);
            BlockPos blockPos = blockHitResult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
        }
        if (this.m_19749_() instanceof LivingEntity && !this.m_9236_().f_46443_) {
            int amount = this.f_19796_.m_188503_(5) + 1;
            int rng = this.f_19796_.m_188503_(6);
            block7: for (int i = 0; i < amount; ++i) {
                switch (rng) {
                    case 1: {
                        WitherSkeleton skeleton = new WitherSkeleton(EntityType.f_20497_, this.m_9236_());
                        skeleton.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        this.initEquip((LivingEntity)skeleton);
                        this.m_9236_().m_7967_((Entity)skeleton);
                        continue block7;
                    }
                    case 2: {
                        LightningBolt lightningEntity = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                        lightningEntity.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        this.m_9236_().m_7967_((Entity)lightningEntity);
                        continue block7;
                    }
                    case 3: {
                        this.randomHostile().m_262496_((ServerLevel)this.m_9236_(), this.m_20183_(), MobSpawnType.EVENT);
                        continue block7;
                    }
                    case 4: {
                        this.randomPassive().m_262496_((ServerLevel)this.m_9236_(), this.m_20183_(), MobSpawnType.EVENT);
                        continue block7;
                    }
                    case 5: {
                        float power = this.f_19796_.m_188501_() * 3.0f;
                        this.m_9236_().m_254877_((Entity)this, this.m_9236_().m_269111_().m_269333_((LivingEntity)this.m_19749_()), new ExplosionDamageCalculator(), this.m_20185_(), this.m_20186_(), this.m_20189_(), power, false, Level.ExplosionInteraction.TNT);
                        continue block7;
                    }
                    default: {
                        for (int j = 0; j < 2; ++j) {
                            BigChungus chungus = new BigChungus((EntityType<? extends BigChungus>)((EntityType)EntityRegistry.BIG_CHUNGUS.get()), this.m_9236_());
                            chungus.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                            this.m_9236_().m_7967_((Entity)chungus);
                        }
                    }
                }
            }
        }
        this.finisher();
    }

    private void initEquip(LivingEntity entity) {
        HashMap<ItemStack, EquipmentSlot> equip = new HashMap<ItemStack, EquipmentSlot>();
        equip.put(new ItemStack((ItemLike)Items.f_42480_), EquipmentSlot.HEAD);
        equip.put(new ItemStack((ItemLike)Items.f_42481_), EquipmentSlot.CHEST);
        equip.put(new ItemStack((ItemLike)Items.f_42482_), EquipmentSlot.LEGS);
        equip.put(new ItemStack((ItemLike)Items.f_42483_), EquipmentSlot.FEET);
        equip.put(new ItemStack((ItemLike)Items.f_42425_), EquipmentSlot.MAINHAND);
        for (ItemStack stack : equip.keySet()) {
            if (!(entity.m_217043_().m_188500_() < 0.5)) continue;
            if (!(stack.m_41720_() instanceof SwordItem)) {
                stack.m_41663_(Enchantments.f_44965_, 2);
                stack.m_41663_(Enchantments.f_44963_, 1);
            }
            entity.m_8061_((EquipmentSlot)equip.get(stack), stack);
        }
    }

    private void finisher() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12555_, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            ParticleHandler.particleSphereList(this.m_9236_(), 100, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
        }
        this.m_146870_();
    }

    private MobEffect getPotionEffect() {
        MobEffect[] effects = new MobEffect[]{MobEffects.f_19617_, MobEffects.f_19594_, MobEffects.f_19610_, MobEffects.f_216964_, MobEffects.f_19607_, MobEffects.f_19619_, MobEffects.f_19598_, MobEffects.f_19612_, MobEffects.f_19609_, MobEffects.f_19603_, MobEffects.f_19620_, MobEffects.f_19599_, MobEffects.f_19604_, MobEffects.f_19611_, MobEffects.f_19614_, MobEffects.f_19605_, MobEffects.f_19597_, MobEffects.f_19591_, MobEffects.f_19596_, MobEffects.f_19600_, MobEffects.f_19613_, MobEffects.f_19615_};
        return effects[this.f_19796_.m_188503_(effects.length)];
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100) {
            this.finisher();
        }
    }

    private EntityType<?> randomHostile() {
        EntityType[] hostileEntities = new EntityType[]{EntityType.f_20551_, EntityType.f_20558_, EntityType.f_20562_, EntityType.f_20566_, EntityType.f_20523_, EntityType.f_20524_, EntityType.f_20526_, EntityType.f_20479_, EntityType.f_20495_, EntityType.f_20497_, EntityType.f_20501_};
        return hostileEntities[this.f_19796_.m_188503_(hostileEntities.length)];
    }

    private EntityType<?> randomPassive() {
        EntityType[] passiveEntities = new EntityType[]{EntityType.f_20549_, EntityType.f_20550_, EntityType.f_20555_, EntityType.f_20556_, EntityType.f_20557_, EntityType.f_147034_, EntityType.f_20457_, EntityType.f_20466_, EntityType.f_20494_, EntityType.f_20504_, EntityType.f_20510_, EntityType.f_20514_, EntityType.f_20516_, EntityType.f_20517_, EntityType.f_20519_};
        return passiveEntities[this.f_19796_.m_188503_(passiveEntities.length)];
    }
}

