/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.ReturningKnightGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ReturningKnight
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int spawnTicks;
    public int deathTicks;
    private int blockBreakingCooldown;
    private static final EntityDataAccessor<Boolean> OBLITERATE = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BLIND = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SUMMON = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RUPTURE = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UNBREAKABLE = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWN = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEATH = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MACE_OF_SPADES = SynchedEntityData.m_135353_(ReturningKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ReturningKnight(EntityType<? extends ReturningKnight> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.BLUE);
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.getDeath()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
        } else if (this.getSpawning()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
        } else if (this.getUnbreakable()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("unbreakable"));
        } else if (this.getSummon()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("summon_warriors"));
        } else if (this.getObliterate()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("obliterate"));
        } else if (this.getBlind()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("blinding_reflection"));
        } else if (this.getRupture()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("rupture"));
        } else if (this.getMaceOfSpades()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("mace_of_spades"));
        } else if (this.m_5912_()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OBLITERATE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BLIND, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SUMMON, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(RUPTURE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(UNBREAKABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SPAWN, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(DEATH, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(MACE_OF_SPADES, (Object)Boolean.FALSE);
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22276_, ConfigConstructor.returning_knight_health).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 8.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ReturningKnightGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    @Override
    public int getTicksUntilDeath() {
        return 70;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setDeath(true);
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get()});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void setObliterate(boolean bl) {
        this.f_19804_.m_135381_(OBLITERATE, (Object)bl);
    }

    public boolean getObliterate() {
        return (Boolean)this.f_19804_.m_135370_(OBLITERATE);
    }

    public void setBlind(boolean bl) {
        this.f_19804_.m_135381_(BLIND, (Object)bl);
    }

    public boolean getBlind() {
        return (Boolean)this.f_19804_.m_135370_(BLIND);
    }

    public void setSummon(boolean bl) {
        this.f_19804_.m_135381_(SUMMON, (Object)bl);
    }

    public boolean getSummon() {
        return (Boolean)this.f_19804_.m_135370_(SUMMON);
    }

    public void setRupture(boolean bl) {
        this.f_19804_.m_135381_(RUPTURE, (Object)bl);
    }

    public boolean getRupture() {
        return (Boolean)this.f_19804_.m_135370_(RUPTURE);
    }

    public void setMaceOfSpades(boolean bl) {
        this.f_19804_.m_135381_(MACE_OF_SPADES, (Object)bl);
    }

    public boolean getMaceOfSpades() {
        return (Boolean)this.f_19804_.m_135370_(MACE_OF_SPADES);
    }

    public void setUnbreakable(boolean bl) {
        this.f_19804_.m_135381_(UNBREAKABLE, (Object)bl);
    }

    public boolean getUnbreakable() {
        return (Boolean)this.f_19804_.m_135370_(UNBREAKABLE);
    }

    public void setSpawning(boolean bl) {
        this.f_19804_.m_135381_(SPAWN, (Object)bl);
    }

    public boolean getSpawning() {
        return (Boolean)this.f_19804_.m_135370_(SPAWN);
    }

    public void setDeath(boolean bl) {
        this.f_19804_.m_135381_(DEATH, (Object)bl);
    }

    public boolean getDeath() {
        return (Boolean)this.f_19804_.m_135370_(DEATH);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getSpawning()) {
            ++this.spawnTicks;
            for (int i = 0; i < 50; ++i) {
                RandomSource random = this.m_217043_();
                BlockPos pos = this.m_20183_();
                double d = random.m_188583_() * 0.05;
                double e = random.m_188583_() * 0.05;
                double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
                double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
                double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 2.0, newZ / 2.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 2.0, newZ / 2.0);
            }
            if (this.spawnTicks % 10 == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.spawnTicks >= 80) {
                this.setSpawning(false);
            }
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f && !this.getDeath()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, this.getAttackingPlayers().size() >= 3 ? 3 : 2));
            double d = this.f_19796_.m_188583_() * 0.05;
            double e = this.f_19796_.m_188583_() * 0.05;
            for (int i = 0; i < 2; ++i) {
                double newX = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + d;
                double newZ = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + e;
                double newY = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20185_(), this.m_20186_() + 5.5, this.m_20189_(), newX * 25.0, newY * 18.0, newZ * 25.0);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Projectile projectile;
        if (this.blockBreakingCooldown <= 0) {
            this.blockBreakingCooldown = 20;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof Projectile && !this.isProjectileWhitelisted((Entity)(projectile = (Projectile)entity))) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public String[] getWhitelistedProjectiles() {
        return ConfigConstructor.returning_knight_projectile_immunity_whitelist;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.returning_knight_disables_shields;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.returning_knight_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.returning_knight_group_type;
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.returning_knight_is_fire_immune;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public int getXp() {
        return ConfigConstructor.returning_knight_xp;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        AABB chunkBox = this.m_20191_().m_82400_(3.0);
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, chunkBox);
        for (Entity entity : nearbyEntities) {
            AbstractArrow projectile;
            if (!(entity instanceof AbstractArrow) || this.isProjectileWhitelisted((Entity)(projectile = (AbstractArrow)entity))) continue;
            projectile.m_20334_(-projectile.m_20184_().m_7096_(), -projectile.m_20184_().m_7098_(), -projectile.m_20184_().m_7094_());
        }
        if (ConfigConstructor.can_bosses_break_blocks && this.blockBreakingCooldown > 0) {
            --this.blockBreakingCooldown;
            if (this.blockBreakingCooldown == 0 && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                int i = Mth.m_14107_((double)this.m_20186_());
                int j = Mth.m_14107_((double)this.m_20185_());
                int k = Mth.m_14107_((double)this.m_20189_());
                for (int l = -3; l <= 3; ++l) {
                    for (int m = -3; m <= 3; ++m) {
                        for (int n = 0; n <= 8; ++n) {
                            BlockPos pos = new BlockPos(j + l, i + n, k + m);
                            if (this.m_9236_().m_8055_(pos).m_60734_() instanceof BaseEntityBlock) continue;
                            this.m_9236_().m_46961_(pos, true);
                        }
                    }
                }
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.DEATH_SCREAMS_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.KNIGHT_HIT_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.KNIGHT_DEATH_EVENT.get();
    }
}

