/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class BigChungus
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_BOSNIAN = SynchedEntityData.m_135353_(BigChungus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean healthUpdated = false;

    public BigChungus(EntityType<? extends BigChungus> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 50;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createChungusAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_6914_(LevelReader view) {
        BlockPos blockUnderEntity = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        BlockPos positionEntity = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        BlockState state = this.m_9236_().m_8055_(positionEntity);
        return view.m_45784_((Entity)this) && this.m_9236_().m_46462_() && !this.m_9236_().m_46855_(this.m_20191_()) && state.m_60734_().m_48673_(state) && this.m_9236_().m_8055_(blockUnderEntity).m_60643_((BlockGetter)view, blockUnderEntity, (EntityType)EntityRegistry.BIG_CHUNGUS.get()) && this.isSpawnable() && this.checkForMonolith();
    }

    public boolean checkForMonolith() {
        BlockPos entityPos = this.m_20183_();
        int radius = ConfigConstructor.chungus_monolith_radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos checkPos = entityPos.m_7918_(x, 0, z);
                Block block = this.m_9236_().m_8055_(checkPos).m_60734_();
                if (block != BlockRegistry.CHUNGUS_MONOLITH.get()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpawnable() {
        return ConfigConstructor.can_moderatly_sized_chungus_spawn;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.BIG_CHUNGUS_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.FART_EVENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12237_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.healthUpdated) {
            int rand = this.m_217043_().m_188503_(100);
            this.setBosnian(rand == 1);
            if (this.isBosnian()) {
                this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
                this.m_21153_(50.0f);
            }
            this.healthUpdated = true;
        }
    }

    public boolean isBosnian() {
        return (Boolean)this.f_19804_.m_135370_(IS_BOSNIAN);
    }

    public void setBosnian(boolean bl) {
        this.f_19804_.m_135381_(IS_BOSNIAN, (Object)bl);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BOSNIAN, (Object)false);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("healthUpdated")) {
            this.healthUpdated = nbt.m_128471_("healthUpdated");
        }
        if (nbt.m_128441_("bosnian")) {
            this.setBosnian(nbt.m_128471_("bosnian"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("healthUpdated", this.healthUpdated);
        nbt.m_128379_("bosnian", this.isBosnian());
    }
}

