/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DraugrBossGoal;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.ShadowOrb;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class NightShadeGoal
extends Goal {
    private int attackCooldown;
    private int attackStatus;
    private final NightShade boss;

    public NightShadeGoal(NightShade boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.boss.m_5448_();
        return target != null && target.m_6084_() && this.boss.m_6779_(target) && this.boss.m_217043_().m_188503_(7) == 0 && !this.boss.getSpawn();
    }

    public boolean m_8045_() {
        return this.boss.getCharging() && this.boss.m_5448_() != null && this.boss.m_5448_().m_6084_();
    }

    public void m_8056_() {
        LivingEntity livingEntity = this.boss.m_5448_();
        if (livingEntity == null) {
            return;
        }
        Vec3 vec3d = livingEntity.m_146892_();
        this.boss.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
        this.boss.setCharging(true);
    }

    public void m_8041_() {
        this.boss.setCharging(false);
        this.reset(0.0f);
    }

    private void reset(float cooldownModifier) {
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor((float)ConfigConstructor.frenzied_shade_cooldown * cooldownModifier);
    }

    private void damageTarget(LivingEntity target, float damage) {
        if (target instanceof NightShade) {
            return;
        }
        target.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(damage));
    }

    private float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.frenzied_shade_damage_modifier * (this.boss.isCopy() ? 0.35f : 1.0f);
    }

    private void randomAttack(LivingEntity target) {
        if (target == null) {
            this.boss.setAttackState(NightShade.AttackStates.IDLE);
            return;
        }
        int rand = this.boss.m_217043_().m_188503_(NightShade.AttackStates.values().length);
        NightShade.AttackStates attack = NightShade.AttackStates.values()[rand];
        switch (attack) {
            case GENERIC_CHARGE: 
            case AOE: 
            case BIG_SWIPES: {
                this.boss.setCharging(true);
                this.boss.setAttackState(attack);
                break;
            }
            case THROW_MOONLIGHT: 
            case SHADOW_ORBS: {
                if (this.boss.m_5830_()) break;
                this.boss.setCharging(true);
                this.boss.setAttackState(attack);
                break;
            }
            default: {
                this.boss.setAttackState(NightShade.AttackStates.IDLE);
            }
        }
    }

    public void m_8037_() {
        if (this.boss.m_21224_() || this.boss.getAttackState().equals((Object)NightShade.AttackStates.DUPLICATE) || this.boss.getSpawn()) {
            return;
        }
        --this.attackCooldown;
        LivingEntity target = this.boss.m_5448_();
        if (target != null) {
            Vec3 vec3d = target.m_146892_();
            if (this.attackCooldown > 0) {
                this.boss.setAttackState(NightShade.AttackStates.IDLE);
                this.moveRandomSpot(vec3d);
            }
            if (this.attackCooldown < 0 && this.boss.getAttackState().equals((Object)NightShade.AttackStates.IDLE)) {
                this.randomAttack(target);
                this.boss.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }
            switch (this.boss.getAttackState()) {
                case BIG_SWIPES: {
                    this.bigSwipes(target);
                    break;
                }
                case GENERIC_CHARGE: {
                    this.genericCharge(target);
                    break;
                }
                case AOE: {
                    this.aoe(target);
                    break;
                }
                case THROW_MOONLIGHT: {
                    this.throwMoonlight(target);
                    break;
                }
                case SHADOW_ORBS: {
                    this.boss.m_21573_().m_26573_();
                    this.shadowBall(target);
                }
            }
        }
    }

    private void moveRandomSpot(Vec3 vec3d) {
        this.boss.m_21566_().m_6849_(vec3d.f_82479_ + (double)this.boss.m_217043_().m_188503_(60) - 30.0, vec3d.f_82480_ + (double)this.boss.m_217043_().m_188503_(20) - 10.0, vec3d.f_82481_ + (double)this.boss.m_217043_().m_188503_(60) - 30.0, 1.5);
    }

    private void bigSwipes(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 1 && target.m_20183_() != null) {
            this.boss.setTargetPos(target.m_20183_());
        }
        if (DraugrBossGoal.isPosNotNullish(this.boss.getTargetPos())) {
            BlockPos pos = this.boss.getTargetPos();
            this.boss.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            this.boss.m_21566_().m_6849_((double)((float)pos.m_123341_() + 2.5f), (double)((float)pos.m_123342_() + 2.0f), (double)((float)pos.m_123343_() + 0.5f), 3.0);
            if (this.attackStatus == 9 || this.attackStatus == 16) {
                this.boss.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (!this.boss.m_9236_().f_46443_) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = -10; j <= 10; ++j) {
                            ((ServerLevel)this.boss.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175827_, (double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.3f + (float)i / 1.5f), (double)((float)pos.m_123343_() + (float)j / 10.0f), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(pos).m_82400_(2.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    this.damageTarget(living, 20.0f);
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 3));
                }
            }
        }
        if (this.attackStatus >= 22) {
            this.reset(1.0f);
        }
    }

    private void genericCharge(LivingEntity target) {
        ++this.attackStatus;
        Vec3 vec3d = target.m_146892_();
        if (this.attackStatus == 1) {
            this.moveRandomSpot(vec3d);
        } else {
            this.boss.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
        }
        if (this.attackStatus > 6 && this.attackStatus % 2 == 0 && this.attackStatus <= 14) {
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(1.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.damageTarget(living, this.attackStatus == 14 ? 18.0f : 12.0f);
            }
        }
        if (this.attackStatus >= 20) {
            this.reset(1.0f);
        }
    }

    private void aoe(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 1 && target.m_20183_() != null) {
            this.boss.setTargetPos(target.m_20183_());
        }
        if (DraugrBossGoal.isPosNotNullish(this.boss.getTargetPos())) {
            BlockPos pos = this.boss.getTargetPos();
            this.boss.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            if (this.attackStatus < 10) {
                this.boss.m_21566_().m_6849_((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 10.0f), (double)pos.m_123343_(), 3.0);
            }
            if (this.attackStatus > 10) {
                this.boss.m_21566_().m_6849_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 4.0);
                if (this.attackStatus == 16) {
                    if (!this.boss.m_9236_().f_46443_) {
                        HashMap<ParticleOptions, Vec3> map = new HashMap<ParticleOptions, Vec3>();
                        map.put((ParticleOptions)ParticleTypes.f_123755_, new Vec3(1.0, 1.0, 1.0));
                        map.put((ParticleOptions)ParticleTypes.f_123745_, new Vec3(1.0, 1.0, 1.0));
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 600, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), map, 1.0f);
                    }
                    this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 0.8f, 1.0f);
                    for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(pos).m_82400_(3.0))) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity living = (LivingEntity)entity;
                        this.damageTarget(living, 25.0f);
                        double x = living.m_20185_() - this.boss.m_20185_();
                        double z = living.m_20189_() - this.boss.m_20189_();
                        living.m_147240_(2.0, -x, -z);
                    }
                }
            }
        }
        if (this.attackStatus >= 22) {
            this.reset(1.0f);
        }
    }

    private void throwMoonlight(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 6) {
            double e = target.m_20185_() - this.boss.m_20185_();
            double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
            double g = target.m_20189_() - this.boss.m_20189_();
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.HOSTILE, 1.0f, 0.75f);
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.VERTICAL_MOONLIGHT_ENTITY_TYPE.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
            projectile.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            projectile.m_6686_(e, f, g, 1.5f, 1.0f);
            projectile.m_36781_(this.getModifiedDamage(25.0f));
            projectile.setHugeExplosion(true);
            projectile.setAgeAndPoints(30, 75, 10);
            this.boss.m_9236_().m_7967_((Entity)projectile);
        }
        if (this.attackStatus >= 10) {
            this.reset(1.0f);
        }
    }

    private void shadowBall(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21573_().m_26573_();
        double e = target.m_20185_() - this.boss.m_20185_();
        double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
        double g = target.m_20189_() - this.boss.m_20189_();
        if (this.attackStatus >= 6 && this.attackStatus <= 15) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 1.0f);
            ShadowOrb orb = new ShadowOrb(this.boss.m_9236_(), (LivingEntity)this.boss, e, f, g, new MobEffect[]{MobEffects.f_216964_, (MobEffect)EffectRegistry.DECAY.get()});
            orb.m_6034_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            orb.m_6686_(e, f, g, 2.0f, 1.0f);
            this.boss.m_9236_().m_7967_((Entity)orb);
        }
        if (this.attackStatus == 16) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
            projectile.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            projectile.m_6686_(e, f, g, 2.0f, 1.0f);
            projectile.setAgeAndPoints(30, 150, 4);
            projectile.m_36781_(this.getModifiedDamage(18.0f));
            projectile.setRotateState(MoonlightProjectile.RotationState.NORMAL);
            this.boss.m_9236_().m_7967_((Entity)projectile);
        }
        if (this.attackStatus >= 25) {
            this.reset(1.0f);
        }
    }
}

