/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.entity.projectile.Cannonball;
import net.soulsweaponry.entity.projectile.ChaosSkull;
import net.soulsweaponry.entity.projectile.ChargedArrow;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.entity.projectile.DragonslayerSwordspearEntity;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;

public class ChaosMonarchGoal
extends Goal {
    private final ChaosMonarch boss;
    private int attackCooldown;
    private int attackStatus;
    private boolean randomOrNot;
    private int controlledProjectile = 0;
    private BlockPos blockPos;

    public ChaosMonarchGoal(ChaosMonarch boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.chaos_monarch_damage_modifier;
    }

    public boolean m_8036_() {
        LivingEntity target = this.boss.m_5448_();
        return target != null && target.m_6084_() && this.boss.m_6779_(target);
    }

    public void m_8041_() {
        super.m_8041_();
        this.boss.setAttack(0);
        this.boss.m_21561_(false);
    }

    public void resetAttack(float cooldownModifier) {
        this.attackStatus = 0;
        this.attackCooldown = this.adjustCooldown(cooldownModifier);
        this.boss.setAttack(0);
        this.randomOrNot = this.boss.m_217043_().m_188499_();
        this.controlledProjectile = this.boss.m_217043_().m_188503_(5);
        this.blockPos = null;
    }

    private int adjustCooldown(float cooldownModifier) {
        int reducedCooldown = Mth.m_14143_((float)(this.boss.m_21233_() / this.boss.m_21223_())) * 4;
        return Mth.m_14143_((float)((float)ConfigConstructor.chaos_monarch_attack_cooldown_ticks * cooldownModifier - (float)reducedCooldown));
    }

    public void randomAttack() {
        int attack = this.boss.m_217043_().m_188503_(5) + 2;
        if (attack == 3 && this.boss.m_5448_() != null && this.boss.m_20280_((Entity)this.boss.m_5448_()) > 40.0) {
            this.boss.setAttack(0);
        } else {
            this.boss.setAttack(attack);
        }
    }

    public void m_8037_() {
        --this.attackCooldown;
        LivingEntity target = this.boss.m_5448_();
        if (target != null) {
            this.boss.m_21561_(true);
            this.boss.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            if (this.attackCooldown < 0) {
                if (this.boss.getAttack() == ChaosMonarch.Attack.IDLE) {
                    this.randomAttack();
                }
                switch (this.boss.getAttack()) {
                    case TELEPORT: {
                        ++this.attackStatus;
                        if (this.attackStatus % 2 == 0 && this.attackStatus < 10 && !this.boss.m_9236_().f_46443_) {
                            ParticleHandler.particleSphere(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), (ParticleOptions)ParticleTypes.f_123760_, 6.0f);
                        }
                        if (this.attackStatus == 23) {
                            this.boss.m_9236_().m_6263_(null, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                            boolean bl = this.teleportAway();
                            if (!bl) {
                                this.explode();
                            } else if (!this.boss.m_9236_().f_46443_) {
                                ParticleHandler.particleSphereList(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123799_, ParticleTypes.f_123799_});
                            }
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(0.5f);
                        break;
                    }
                    case MELEE: {
                        ++this.attackStatus;
                        if (this.attackStatus < 5) {
                            this.blockPos = target.m_20183_();
                        }
                        if (this.blockPos != null) {
                            this.boss.m_21563_().m_24946_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_());
                            if (this.attackStatus == 8) {
                                this.hitBox(this.blockPos, HitboxType.SWIPE);
                            }
                            if (this.attackStatus == 16) {
                                this.hitBox(this.blockPos, HitboxType.SWIPE);
                            }
                            if (this.attackStatus == 27) {
                                this.hitBox(this.blockPos, HitboxType.THRUST);
                            }
                            if (this.attackStatus == 39) {
                                this.hitBox(this.blockPos, HitboxType.BONK);
                            }
                        }
                        if (this.attackStatus < 45) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case LIGHTNING: {
                        ++this.attackStatus;
                        int[] triggers = new int[]{15, 20, 25};
                        if (this.attackStatus == 5) {
                            this.boss.m_9236_().m_6263_(null, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), SoundEvents.f_12616_, SoundSource.HOSTILE, 1.0f, 1.5f);
                        }
                        for (int i = 1; i < triggers.length + 1; ++i) {
                            if (this.attackStatus != triggers[i - 1]) continue;
                            this.spawnLightning(i);
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case SHOOT: {
                        ++this.attackStatus;
                        if (this.attackStatus % 6 == 0) {
                            this.chaosSkull(target);
                        }
                        if (this.attackStatus < 40) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                    case BARRAGE: {
                        ++this.attackStatus;
                        if (this.attackStatus >= 9 && this.attackStatus < 25) {
                            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 2.0f, 1.0f);
                            if (this.randomOrNot) {
                                this.randomProjectiles();
                            } else {
                                this.controlledProjectiles(target);
                            }
                        }
                        if (this.attackStatus < 30) break;
                        this.resetAttack(1.0f);
                        break;
                    }
                }
            }
        }
    }

    private void hitBox(BlockPos blockPos, HitboxType type) {
        switch (type.ordinal()) {
            case 0: {
                this.boss.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.generateHitbox(blockPos, 3.0, 15.0f);
                break;
            }
            case 1: {
                this.boss.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12316_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.generateHitbox(blockPos, 2.0, 20.0f);
                break;
            }
            case 2: {
                this.generateHitbox(blockPos, 2.0, 30.0f);
                this.boss.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12555_, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.boss.m_9236_().f_46443_) break;
                ParticleHandler.particleSphereList(this.boss.m_9236_(), 100, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            }
        }
    }

    private void generateHitbox(BlockPos blockPos, double expand, float damage) {
        AABB box = new AABB(blockPos).m_82400_(expand);
        List intersectingEntities = this.boss.m_9236_().m_45933_((Entity)this.boss, box);
        for (Entity entity : intersectingEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(damage));
            livingEntity.m_147240_(this.boss.m_217043_().m_188500_(), this.boss.m_20185_() - livingEntity.m_20185_(), this.boss.m_20189_() - livingEntity.m_20189_());
        }
    }

    private void chaosSkull(LivingEntity target) {
        double e = target.m_20185_() - this.boss.m_20185_();
        double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
        double g = target.m_20189_() - this.boss.m_20189_();
        ChaosSkull skull = new ChaosSkull(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_(), e, f + 1.0, g, this.boss.m_9236_());
        skull.m_5602_((Entity)this.boss);
        this.boss.m_9236_().m_7967_((Entity)skull);
        this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12558_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    private void controlledProjectiles(LivingEntity target) {
        double e = target.m_20185_() - this.boss.m_20185_();
        double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
        double g = target.m_20189_() - this.boss.m_20189_();
        Vec3 vel = new Vec3(e, f, g).m_82490_(0.15);
        switch (this.controlledProjectile) {
            case 1: {
                ShulkerBullet bullet = new ShulkerBullet(this.boss.m_9236_(), (LivingEntity)this.boss, (Entity)target, this.boss.m_6374_().m_122434_());
                bullet.m_146884_(this.getBossPos());
                this.boss.m_9236_().m_7967_((Entity)bullet);
                break;
            }
            case 2: {
                ThrownExperienceBottle bottle = new ThrownExperienceBottle(EntityType.f_20485_, this.boss.m_9236_());
                bottle.m_146884_(this.getBossPos());
                bottle.m_20256_(vel);
                this.boss.m_9236_().m_7967_((Entity)bottle);
                break;
            }
            case 3: {
                if (this.attackStatus % 2 == 0 && this.attackStatus > 18) {
                    LargeFireball fireball = new LargeFireball(this.boss.m_9236_(), (LivingEntity)this.boss, e, f, g, this.boss.m_217043_().m_188503_(3) + 1);
                    fireball.m_146884_(this.getBossPos());
                    this.boss.m_9236_().m_7967_((Entity)fireball);
                    break;
                }
                if (this.attackStatus >= 16) break;
                SmallFireball fireball = new SmallFireball(this.boss.m_9236_(), this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_(), e, f, g);
                this.boss.m_9236_().m_7967_((Entity)fireball);
                break;
            }
            case 4: {
                Snowball snow = new Snowball(EntityType.f_20477_, this.boss.m_9236_());
                snow.m_146884_(this.getBossPos());
                snow.m_20256_(vel);
                this.boss.m_9236_().m_7967_((Entity)snow);
                break;
            }
            default: {
                SpectralArrow arrow = new SpectralArrow(EntityType.f_20478_, this.boss.m_9236_());
                arrow.m_146884_(this.getBossPos());
                arrow.m_36781_(8.0);
                arrow.m_20334_(vel.m_7096_(), vel.m_7098_() + (double)0.2f, vel.m_7094_());
                this.boss.m_9236_().m_7967_((Entity)arrow);
            }
        }
    }

    private Vec3 getBossPos() {
        return new Vec3(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
    }

    private void randomProjectiles() {
        Projectile[] projectiles = new Projectile[]{new Arrow(this.boss.m_9236_(), (LivingEntity)this.boss), new DragonFireball(EntityType.f_20561_, this.boss.m_9236_()), new LargeFireball(EntityType.f_20463_, this.boss.m_9236_()), new LlamaSpit(EntityType.f_20467_, this.boss.m_9236_()), new SmallFireball(EntityType.f_20527_, this.boss.m_9236_()), new SpectralArrow(this.boss.m_9236_(), (LivingEntity)this.boss), new WitherSkull(EntityType.f_20498_, this.boss.m_9236_()), new ThrownEgg(EntityType.f_20483_, this.boss.m_9236_()), new ThrownExperienceBottle(EntityType.f_20485_, this.boss.m_9236_()), new Snowball(EntityType.f_20477_, this.boss.m_9236_()), new ThrownTrident(EntityType.f_20487_, this.boss.m_9236_()), new Cannonball(this.boss.m_9236_(), (LivingEntity)this.boss), new ChargedArrow((EntityType<? extends ChargedArrow>)((EntityType)EntityRegistry.CHARGED_ARROW_ENTITY_TYPE.get()), this.boss.m_9236_()), new CometSpearEntity((EntityType<? extends CometSpearEntity>)((EntityType)EntityRegistry.COMET_SPEAR_ENTITY_TYPE.get()), this.boss.m_9236_()), new DragonslayerSwordspearEntity((EntityType<? extends DragonslayerSwordspearEntity>)((EntityType)EntityRegistry.SWORDSPEAR_ENTITY_TYPE.get()), this.boss.m_9236_()), new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), this.boss.m_9236_()), new SilverBulletEntity((EntityType<? extends SilverBulletEntity>)((EntityType)EntityRegistry.SILVER_BULLET_ENTITY_TYPE.get()), this.boss.m_9236_())};
        if (this.boss.m_5448_() != null) {
            LivingEntity target = this.boss.m_5448_();
            double e = target.m_20185_() - this.boss.m_20185_();
            double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
            double g = target.m_20189_() - this.boss.m_20189_();
            int random = this.boss.m_217043_().m_188503_(projectiles.length);
            Projectile entity = projectiles[random];
            if (entity instanceof LargeFireball) {
                entity = new LargeFireball(this.boss.m_9236_(), (LivingEntity)this.boss, e, f, g, this.boss.m_217043_().m_188503_(3) + 1);
            }
            entity.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            if (entity instanceof AbstractArrow) {
                ((AbstractArrow)entity).m_36781_(6.0);
            }
            entity.m_20256_(new Vec3(e, f + 1.0, g).m_82490_(0.15));
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
    }

    private void spawnLightning(int multiplier) {
        int r = 5 * multiplier;
        for (int theta = 0; theta < 360; theta += 30) {
            double x0 = this.boss.m_20185_();
            double z0 = this.boss.m_20189_();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            BlockPos pos = BlockPos.m_274561_((double)x, (double)this.boss.m_20186_(), (double)z);
            LightningBolt entity = new LightningBolt(EntityType.f_20465_, this.boss.m_9236_());
            entity.m_20343_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
    }

    protected boolean teleportAway() {
        if (this.boss.m_9236_().m_5776_() || !this.boss.m_6084_()) {
            return false;
        }
        double d = this.boss.m_20185_() + (this.boss.m_217043_().m_188500_() - 0.5) * 64.0;
        double e = this.boss.m_20186_() + (double)(this.boss.m_217043_().m_188503_(64) - 16);
        double f = this.boss.m_20189_() + (this.boss.m_217043_().m_188500_() - 0.5) * 64.0;
        return this.teleportTo(d, e, f);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (mutable.m_123342_() > this.boss.m_9236_().m_141937_() && !this.boss.m_9236_().m_8055_((BlockPos)mutable).m_280555_()) {
            mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.boss.m_9236_().m_8055_((BlockPos)mutable);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!bl || bl2) {
            return false;
        }
        Vec3 vec3d = this.boss.m_20182_();
        boolean bl3 = this.boss.m_20984_(x, y, z, true);
        if (bl3) {
            this.boss.m_9236_().m_214171_(GameEvent.f_238175_, vec3d, GameEvent.Context.m_223717_((Entity)this.boss));
            if (!this.boss.m_20067_()) {
                this.boss.m_9236_().m_6263_(null, this.boss.f_19854_, this.boss.f_19855_, this.boss.f_19856_, SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.boss.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    private void explode() {
        this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 5.0f, 1.0f);
        AABB chunkBox = new AABB(this.boss.m_20183_()).m_82400_(5.0);
        List nearbyEntities = this.boss.m_9236_().m_45933_((Entity)this.boss, chunkBox);
        for (Entity nearbyEntity : nearbyEntities) {
            if (!(nearbyEntity instanceof LivingEntity)) continue;
            LivingEntity closestTarget = (LivingEntity)nearbyEntity;
            double x = closestTarget.m_20185_() - this.boss.m_20185_();
            double z = closestTarget.m_20189_() - this.boss.m_20189_();
            closestTarget.m_147240_(10.0, -x, -z);
            closestTarget.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(30.0f));
        }
        if (!this.boss.m_9236_().f_46443_) {
            ParticleHandler.particleSphereList(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123745_, ParticleTypes.f_123755_});
        }
    }

    static enum HitboxType {
        SWIPE,
        THRUST,
        BONK;

    }
}

