/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.client.model.entity.mobs.MoonknightModel;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MoonknightRenderer
extends GeoEntityRenderer<Moonknight> {
    int[] rgbColorOne = new int[]{254, 200, 203};
    int[] rgbColorTwo = new int[]{254, 254, 218};
    int[] rgbColorThree = new int[]{106, 73, 156};
    int[] rgbColorFour = new int[]{176, 253, 252};
    double[] translation = new double[]{0.0, 4.0, 0.0};
    public static final ResourceLocation CRYSTAL_BEAM_TEXTURE = new ResourceLocation("soulsweapons", "textures/entity/core_beam.png");
    private static final RenderType CRYSTAL_BEAM_LAYER = RenderType.m_110476_((ResourceLocation)CRYSTAL_BEAM_TEXTURE);

    public MoonknightRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new MoonknightModel());
        this.f_114477_ = 2.5f;
    }

    protected float getDeathMaxRotation(Moonknight entityLivingBaseIn) {
        return 0.0f;
    }

    public void render(Moonknight entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((LivingEntity)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        BlockPos blockPos = entity.getBeamLocation();
        if (entity.getCanBeam() && blockPos != null && !entity.m_21224_()) {
            float yOffset = 4.0f;
            if (entity.getIncreasingBeamHeight()) {
                entity.setBeamHeight(0.0325f + entity.getBeamHeight());
            } else {
                entity.setBeamHeight(0.0f);
            }
            float m = (float)blockPos.m_123341_() + 0.5f;
            float n = (float)blockPos.m_123342_() + entity.getBeamHeight();
            float o = (float)blockPos.m_123343_() + 0.5f;
            float p = (float)((double)m - entity.m_20185_());
            float q = (float)((double)n - entity.m_20186_());
            float r = (float)((double)o - entity.m_20189_());
            stack.m_252880_(p, q, r);
            MoonknightRenderer.renderCoreBeam(-p, -q + yOffset, -r, partialTicks, entity.f_19797_, stack, bufferIn, packedLightIn);
        }
    }

    private static void renderCoreBeam(float dx, float dy, float dz, float tickDelta, int age, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        float xzLength = Mth.m_14116_((float)(dx * dx + dz * dz));
        float vecLength = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 2.0f, 0.0f);
        matrices.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrices.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzLength, dy)) - 1.5707964f));
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(CRYSTAL_BEAM_LAYER);
        float h = 0.0f - ((float)age + tickDelta) * 0.01f;
        float i = vecLength / 32.0f - ((float)age + tickDelta) * 0.01f;
        float k = 0.0f;
        float l = 0.75f;
        float m = 0.0f;
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        for (int n = 1; n <= 8; ++n) {
            float o = Mth.m_14031_((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float p = Mth.m_14089_((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float q = (float)n / 8.0f;
            vertexConsumer.m_252986_(matrix4f, k * 0.2f, l * 0.2f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(m, h).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, k, l, vecLength).m_6122_(255, 255, 255, 255).m_7421_(m, i).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, o, p, vecLength).m_6122_(255, 255, 255, 255).m_7421_(q, i).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, o * 0.2f, p * 0.2f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(q, h).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            k = o;
            l = p;
            m = q;
        }
        matrices.m_85849_();
    }
}

