/*
 * Decompiled with CFR 0.152.
 */
package baguchan.slash_illager.message;

import baguchan.slash_illager.animation.VanillaConvertedVmdAnimation;
import baguchan.slash_illager.client.ClientRenderingRegistry;
import baguchan.slash_illager.entity.IBladeAnimation;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class MotionEntityBroadcastMessage {
    public int id;
    public String combo;

    public static MotionEntityBroadcastMessage decode(FriendlyByteBuf buf) {
        MotionEntityBroadcastMessage msg = new MotionEntityBroadcastMessage();
        msg.id = buf.readInt();
        msg.combo = buf.m_130277_();
        return msg;
    }

    public static void encode(MotionEntityBroadcastMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.id);
        buf.m_130070_(msg.combo);
    }

    public static void handle(MotionEntityBroadcastMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        BiConsumer handler = (BiConsumer)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> MotionEntityBroadcastMessage::setPoint);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(msg.id, msg.combo));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setPoint(int entityId, String combo) {
        VanillaConvertedVmdAnimation vmdAnimation;
        Entity target = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
        if (target == null) {
            return;
        }
        if (!(target instanceof IBladeAnimation)) {
            return;
        }
        IBladeAnimation bladeMaster = (IBladeAnimation)target;
        ComboState state = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(ResourceLocation.m_135820_((String)combo));
        if (state == null) {
            return;
        }
        ResourceLocation animation = ComboState.getRegistryKey((ComboState)state);
        if (animation != null && target.m_9236_().m_5776_() && (vmdAnimation = ClientRenderingRegistry.animation.get(animation)) != null) {
            bladeMaster.setCurrentAnimation(vmdAnimation.getClone());
        }
    }
}

