/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.impl.entity.ChestMinecart;
import compasses.expandedstorage.impl.recipe.ConversionRecipe;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.impl.recipe.misc.RecipeTool;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityConversionRecipe<O extends Entity>
extends ConversionRecipe<Entity> {
    private final EntityType<O> output;

    public EntityConversionRecipe(RecipeTool recipeTool, EntityType<O> output, RecipeCondition input) {
        super(recipeTool, input);
        this.output = output;
    }

    public InteractionResult process(Level level, Player player, ItemStack tool, Entity input) {
        if (tool.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (input.m_6095_() == this.output) {
            return InteractionResult.FAIL;
        }
        if (!EntityConversionRecipe.simulateSpawnUpgradedMinecartChest(input)) {
            return InteractionResult.FAIL;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChestMinecart newCart = (ChestMinecart)this.output.m_262451_(serverLevel, null, cart -> {
            boolean isMinecraftCart = input instanceof AbstractMinecartContainer;
            NonNullList<ItemStack> items = isMinecraftCart ? ((AbstractMinecartContainer)input).m_213659_() : ((ChestMinecart)input).getItems();
            int inserted = cart.replaceInventoryWith(items);
            if (inserted < items.size()) {
                Vec3 pos = input.m_20182_();
                for (int i = inserted; i < items.size(); ++i) {
                    Containers.m_18992_((Level)level, (double)pos.m_7096_(), (double)pos.m_7098_(), (double)pos.m_7094_(), (ItemStack)((ItemStack)items.get(i)));
                }
            }
            cart.m_146884_(input.m_20182_());
            cart.m_146926_(input.m_146909_());
            cart.m_146922_(input.m_146908_());
            cart.m_20256_(input.m_20184_());
            if (input.m_8077_()) {
                cart.m_6593_(input.m_7770_());
            }
        }, input.m_20097_(), MobSpawnType.COMMAND, true, false);
        if (newCart == null) {
            return InteractionResult.FAIL;
        }
        serverLevel.m_47205_((Entity)newCart);
        ((Clearable)input).m_6211_();
        input.m_142687_(Entity.RemovalReason.DISCARDED);
        if (this.recipeTool instanceof RecipeTool.UpgradeTool && !player.m_7500_()) {
            tool.m_41764_(tool.m_41613_() - 1);
        }
        return InteractionResult.CONSUME;
    }

    private static boolean simulateSpawnUpgradedMinecartChest(Entity original) {
        boolean isMinecraftCart = original instanceof AbstractMinecartContainer;
        boolean isOurCart = original instanceof ChestMinecart;
        return isOurCart || isMinecraftCart;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        this.recipeTool.writeToBuffer(buffer);
        buffer.m_130085_(BuiltInRegistries.f_256780_.m_7981_(this.output));
        buffer.m_130085_(this.input.getNetworkId());
        this.input.writeToBuffer(buffer);
    }

    public static EntityConversionRecipe<?> readFromBuffer(FriendlyByteBuf buffer) {
        RecipeTool recipeTool = RecipeTool.fromNetworkBuffer(buffer);
        EntityType output = (EntityType)BuiltInRegistries.f_256780_.m_7745_(buffer.m_130281_());
        RecipeCondition input = RecipeCondition.readFromNetworkBuffer(buffer);
        return new EntityConversionRecipe(recipeTool, output, input);
    }

    @Override
    public JsonElement toJson() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "expandedstorage:entity_conversion");
        recipe.add("tool", (JsonElement)this.recipeTool.toJson());
        recipe.addProperty("result", this.output.m_204041_().m_205785_().m_135782_().toString());
        recipe.add("inputs", this.input.toJson(null));
        return recipe;
    }
}

