/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.handler.InventorySlotFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableSidedInventory
implements WorldlyContainer {
    private final WorldlyContainer[] parts;
    private final int size;
    private final int maxStackCount;
    private final Map<Direction, int[]> slotsAccessibleThroughFace = new HashMap<Direction, int[]>();

    private VariableSidedInventory(WorldlyContainer ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            assert (parts[i] != null) : "part at index " + i + " must not be null";
        }
        this.parts = parts;
        this.size = Arrays.stream(parts).mapToInt(Container::m_6643_).sum();
        this.maxStackCount = parts[0].m_6893_();
        for (WorldlyContainer part : parts) {
            assert (part.m_6893_() == this.maxStackCount) : "all parts must have equal max stack counts.";
        }
    }

    public static WorldlyContainer of(WorldlyContainer ... parts) {
        assert (parts.length > 0) : "parts must contain at least 1 inventory";
        if (parts.length == 1) {
            return parts[0];
        }
        return new VariableSidedInventory(parts);
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        for (WorldlyContainer part : this.parts) {
            if (part.m_7983_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, Container::m_8020_);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7407_(rSlot, amount));
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, Container::m_8016_);
    }

    public void m_6836_(int slot, ItemStack stack) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        this.consumeSlot(slot, (part, rSlot) -> part.m_6836_(rSlot, stack));
    }

    public int m_6893_() {
        return this.maxStackCount;
    }

    public void m_6596_() {
        for (WorldlyContainer part : this.parts) {
            part.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        for (WorldlyContainer part : this.parts) {
            if (part.m_6542_(player)) continue;
            return false;
        }
        return true;
    }

    public void m_5856_(Player player) {
        for (WorldlyContainer part : this.parts) {
            part.m_5856_(player);
        }
    }

    public void m_5785_(Player player) {
        for (WorldlyContainer part : this.parts) {
            part.m_5785_(player);
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7013_(rSlot, stack));
    }

    public int m_18947_(Item item) {
        int count = 0;
        for (WorldlyContainer part : this.parts) {
            count += part.m_18947_(item);
        }
        return count;
    }

    public boolean m_18949_(Set<Item> set) {
        for (WorldlyContainer part : this.parts) {
            if (!part.m_18949_(set)) continue;
            return true;
        }
        return false;
    }

    public void m_6211_() {
        for (WorldlyContainer part : this.parts) {
            part.m_6211_();
        }
    }

    public int @NotNull [] m_7071_(Direction direction) {
        return this.slotsAccessibleThroughFace.computeIfAbsent(direction, dir -> {
            int previousSize = 0;
            IntArrayList list = new IntArrayList();
            for (WorldlyContainer part : this.parts) {
                for (int i : part.m_7071_(dir)) {
                    list.add(i + previousSize);
                }
                previousSize += part.m_6643_();
            }
            return list.toIntArray();
        });
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7155_(rSlot, stack, direction));
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        assert (slot >= 0 && slot < this.m_6643_()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.m_7157_(rSlot, stack, direction));
    }

    private void consumeSlot(int slot, ObjIntConsumer<WorldlyContainer> consumer) {
        for (WorldlyContainer part : this.parts) {
            int inventorySize = part.m_6643_();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            consumer.accept(part, slot);
            return;
        }
        throw new IllegalStateException("consumeSlot called without validating slot bounds.");
    }

    private <T> T applyFunctionToSlot(int slot, InventorySlotFunction<WorldlyContainer, T> function) {
        for (WorldlyContainer part : this.parts) {
            int inventorySize = part.m_6643_();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            return function.apply(part, slot);
        }
        throw new IllegalStateException("applyFunctionToSlot called without validating slot bounds.");
    }

    public boolean containsPart(WorldlyContainer part) {
        for (WorldlyContainer inventory : this.parts) {
            if (inventory != part) continue;
            return true;
        }
        return false;
    }
}

