/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.entity;

import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.client.helpers.InventoryOpeningApi;
import compasses.expandedstorage.impl.inventory.ExposedInventory;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.OpenableInventoryProvider;
import compasses.expandedstorage.impl.inventory.context.BaseContext;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChestMinecart
extends AbstractMinecart
implements ExposedInventory,
OpenableInventoryProvider<BaseContext>,
OpenableInventory {
    private final NonNullList<ItemStack> inventory;
    private final Item dropItem;
    private final BlockState renderBlockState;
    private final Component title;
    private final Item chestItem;

    public ChestMinecart(EntityType<?> entityType, Level level, Item dropItem, ChestBlock block) {
        super(entityType, level);
        this.dropItem = dropItem;
        this.renderBlockState = block.m_49966_();
        this.title = dropItem.m_41466_();
        this.inventory = NonNullList.m_122780_((int)block.getSlotCount(), (Object)ItemStack.f_41583_);
        this.chestItem = block.m_5456_();
    }

    @NotNull
    protected Item m_213728_() {
        return this.dropItem;
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.dropItem);
    }

    @NotNull
    public BlockState m_38178_() {
        return this.renderBlockState;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        boolean isClient = this.m_9236_().m_5776_();
        if (!isClient) {
            InventoryOpeningApi.openEntityInventory((ServerPlayer)player, this);
        }
        return InteractionResult.m_19078_((boolean)isClient);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_() && reason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    @Override
    public void onInitialOpen(ServerPlayer player) {
        if (!player.m_9236_().m_5776_()) {
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public void m_7617_(DamageSource source) {
        this.m_6074_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            Entity breaker = source.m_7640_();
            if (breaker != null && breaker.m_6144_()) {
                ItemStack stack = new ItemStack((ItemLike)this.chestItem);
                if (this.m_8077_()) {
                    stack.m_41714_(this.m_7770_());
                }
                this.m_19983_(stack);
                this.m_19998_((ItemLike)Items.f_42449_);
            } else {
                ItemStack stack = new ItemStack((ItemLike)this.m_213728_());
                if (this.m_8077_()) {
                    stack.m_41714_(this.m_7770_());
                }
                this.m_19983_(stack);
            }
            if (!this.m_9236_().m_5776_() && breaker != null && breaker.m_6095_() == EntityType.f_20532_) {
                PiglinAi.m_34873_((Player)((Player)breaker), (boolean)true);
            }
        }
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public static ChestMinecart createMinecart(Level level, Vec3 pos, ResourceLocation cartItemId) {
        return level.m_9598_().m_6632_(Registries.f_256939_).map(registry -> {
            ChestMinecart cart = (ChestMinecart)((EntityType)registry.m_7745_(cartItemId)).m_20615_(level);
            cart.m_146884_(pos);
            return cart;
        }).orElse(null);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public void m_6596_() {
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.m_6084_() && player.m_20280_((Entity)this) <= 64.0;
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveInventoryToTag(tag);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadInventoryFromTag(tag);
    }

    @Override
    public OpenableInventory getOpenableInventory(BaseContext context) {
        return this;
    }

    @Override
    public boolean canBeUsedBy(ServerPlayer player) {
        return this.m_6542_((Player)player);
    }

    @Override
    public Container getInventory() {
        return this;
    }

    @Override
    public Component getInventoryTitle() {
        return this.m_8077_() ? this.m_7770_() : this.title;
    }

    public int m_7144_() {
        return 8;
    }
}

