/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.config;

import compasses.expandedstorage.impl.client.config.Config;
import compasses.expandedstorage.impl.client.config.Converter;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ConfigV0
implements Config {
    private final boolean restrictiveScrolling;
    private final boolean preferSmallerScreens;
    private ResourceLocation screenType;
    private final boolean fitVanillaConstraints;

    public ConfigV0() {
        this(null, false, true, false);
    }

    public ConfigV0(ResourceLocation screenType, boolean restrictiveScrolling, boolean preferSmallerScreens, boolean fitVanillaConstraints) {
        this.screenType = String.valueOf(screenType).equals("expandedstorage:auto") ? null : screenType;
        this.restrictiveScrolling = restrictiveScrolling;
        this.preferSmallerScreens = preferSmallerScreens;
        this.fitVanillaConstraints = fitVanillaConstraints;
    }

    public ResourceLocation getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ResourceLocation screenType) {
        this.screenType = screenType;
    }

    public boolean isScrollingRestricted() {
        return this.restrictiveScrolling;
    }

    public boolean preferSmallerScreens() {
        return this.preferSmallerScreens;
    }

    public boolean fitVanillaConstraints() {
        return this.fitVanillaConstraints;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public Converter<Map<String, Object>, ConfigV0> getConverter() {
        return Factory.INSTANCE;
    }

    public static final class Factory
    implements Converter<Map<String, Object>, ConfigV0> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public ConfigV0 fromSource(Map<String, Object> source) {
            Object object = source.get("container_type");
            if (object instanceof String) {
                String screenType = (String)object;
                object = source.get("restrictive_scrolling");
                if (object instanceof Boolean) {
                    Object object2;
                    Boolean bool;
                    Object object3;
                    Boolean restrictiveScrolling = (Boolean)object;
                    Boolean preferSmallerScreens = Boolean.FALSE;
                    if (source.containsKey("prefer_smaller_screens") && (object3 = source.get("prefer_smaller_screens")) instanceof Boolean) {
                        preferSmallerScreens = bool = (Boolean)object3;
                    }
                    if (source.containsKey("prefer_bigger_screens") && (object3 = source.get("prefer_bigger_screens")) instanceof Boolean) {
                        preferSmallerScreens = bool = (Boolean)object3;
                    }
                    ResourceLocation screenTypeRl = switch (screenType) {
                        case "expandedstorage:page" -> Utils.PAGINATED_SCREEN_TYPE;
                        case "expandedstorage:scroll" -> Utils.SCROLLABLE_SCREEN_TYPE;
                        default -> ResourceLocation.m_135820_((String)screenType);
                    };
                    Boolean fitVanillaConstraints = Boolean.FALSE;
                    if (source.containsKey("fit_vanilla_constraints") && (object2 = source.get("fit_vanilla_constraints")) instanceof Boolean) {
                        Boolean bool2;
                        fitVanillaConstraints = bool2 = (Boolean)object2;
                    }
                    return new ConfigV0(screenTypeRl, restrictiveScrolling, preferSmallerScreens, fitVanillaConstraints);
                }
            }
            return null;
        }

        @Override
        public Map<String, Object> toSource(ConfigV0 target) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("container_type", target.screenType);
            values.put("restrictive_scrolling", target.restrictiveScrolling);
            values.put("prefer_smaller_screens", target.preferSmallerScreens);
            values.put("fit_vanilla_constraints", target.fitVanillaConstraints);
            return values;
        }

        @Override
        public int getSourceVersion() {
            return 0;
        }

        @Override
        public int getTargetVersion() {
            return 0;
        }
    }
}

