/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.entity;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.block.strategies.Observable;
import compasses.expandedstorage.impl.inventory.VariableInventory;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class ChestBlockEntity
extends OldChestBlockEntity {
    private final ContainerOpenersCounter manager = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            ChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            ChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
            level.m_7696_(pos, state.m_60734_(), 1, newCount);
        }

        protected boolean m_142718_(Player player) {
            VariableInventory variableInventory;
            AbstractHandler handler;
            WorldlyContainer inventory = ChestBlockEntity.this.getInventory();
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof AbstractHandler && ((handler = (AbstractHandler)abstractContainerMenu).getInventory() == inventory || (abstractContainerMenu = handler.getInventory()) instanceof VariableInventory && (variableInventory = (VariableInventory)abstractContainerMenu).containsPart((Container)inventory));
        }
    };
    private final ChestLidController lidController;

    public ChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ResourceLocation blockId, Function<OpenableBlockEntity, ItemAccess> access, Supplier<Lockable> lockable) {
        super(type, pos, state, blockId, access, lockable);
        this.setObservable(new Observable(){

            @Override
            public void playerStartViewing(Player player) {
                ChestBlockEntity self = ChestBlockEntity.this;
                ChestBlockEntity.this.manager.m_155452_(player, self.m_58904_(), self.m_58899_(), self.m_58900_());
            }

            @Override
            public void playerStopViewing(Player player) {
                ChestBlockEntity self = ChestBlockEntity.this;
                ChestBlockEntity.this.manager.m_155468_(player, self.m_58904_(), self.m_58899_(), self.m_58900_());
            }
        });
        this.lidController = new ChestLidController();
    }

    public static void progressLidAnimation(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ((ChestBlockEntity)blockEntity).lidController.m_155374_();
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        Vec3 soundPos;
        DoubleBlockCombiner.BlockType mergeType = AbstractChestBlock.getBlockType((EsChestType)((Object)state.m_61143_(AbstractChestBlock.CURSED_CHEST_TYPE)));
        if (mergeType == DoubleBlockCombiner.BlockType.SINGLE) {
            soundPos = Vec3.m_82512_((Vec3i)pos);
        } else if (mergeType == DoubleBlockCombiner.BlockType.FIRST) {
            soundPos = Vec3.m_82512_((Vec3i)pos).m_82549_(Vec3.m_82528_((Vec3i)AbstractChestBlock.getDirectionToAttached(state).m_122436_()).m_82490_(0.5));
        } else {
            return;
        }
        level.m_6263_(null, soundPos.m_7096_(), soundPos.m_7098_(), soundPos.m_7094_(), sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int event, int value) {
        if (event == 1) {
            this.lidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(event, value);
    }

    public float getLidOpenness(float delta) {
        return this.lidController.m_155375_(delta);
    }

    public void updateViewerCount(ServerLevel level, BlockPos pos, BlockState state) {
        this.manager.m_155476_((Level)level, pos, state);
    }
}

