/*
 * Decompiled with CFR 0.152.
 */
package com.deltajay.tonsofenchants.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class PU {
    public static Set<BlockPos> processedBlocks2 = new HashSet<BlockPos>();

    public boolean verify(RegistryObject<Enchantment> enchant, ItemStack stack, boolean config) {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)enchant.get()), (ItemStack)stack) > 0 && config;
    }

    public static void lifeSteal(Entity entity, float amount) {
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21223_() < ((LivingEntity)entity).m_21233_()) {
            ((LivingEntity)entity).m_5634_(amount);
        }
    }

    public static void explode(LivingEntity player, Vec3 pos, float explosionSize) {
        player.m_9236_().m_254849_((Entity)player, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), explosionSize, Level.ExplosionInteraction.TNT);
    }

    public static void nonDestructiveExplode(LivingEntity player, Vec3 pos, float explosionSize) {
        player.m_9236_().m_255391_((Entity)player, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), explosionSize, false, Level.ExplosionInteraction.NONE);
    }

    public static void explode(LivingEntity player, BlockPos pos, float explosionSize) {
        player.m_9236_().m_254849_((Entity)player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), explosionSize, Level.ExplosionInteraction.TNT);
    }

    public static void nonDestructiveExplode(LivingEntity player, BlockPos pos, float explosionSize) {
        player.m_9236_().m_255391_((Entity)player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), explosionSize, false, Level.ExplosionInteraction.NONE);
    }

    public static void doOnExtraBlocks(LivingEntity player, BlockPos destroyPos, Consumer<BlockPos> posConsumer) {
        Direction horizontalDirection = player.m_6350_();
        boolean vertical = !player.m_9236_().m_8055_(destroyPos.m_7494_()).m_60795_();
        BlockPos startPos = vertical ? destroyPos.m_7494_().m_5484_(horizontalDirection.m_122427_(), 1) : destroyPos.m_122012_().m_122024_();
        BlockPos endPos = vertical ? destroyPos.m_7495_().m_5484_(horizontalDirection.m_122428_(), 1) : destroyPos.m_122019_().m_122029_();
        BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos).forEach(p -> {
            if (!p.equals((Object)destroyPos) && !player.m_9236_().m_8055_(p).m_60795_()) {
                posConsumer.accept((BlockPos)p);
            }
        });
    }

    public static double generateRandomNumberBetween(double min, double max) {
        return new Random().nextDouble() * (max - min) + min;
    }

    public static void jump(LivingEntity entity, int amplifier) {
        if (entity.m_20096_()) {
            double motionY = 0.04 * (double)(amplifier + 1);
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, motionY, 0.0));
        }
    }

    public static void doForEachEntity(LivingEntity player, int radius, int yRadius, Consumer<Entity> entityConsumer) {
        if (player == null) {
            return;
        }
        List nearEntities = player.m_9236_().m_45933_((Entity)player, PU.getBoundingBoxAroundPlayer(player.m_20182_(), radius, yRadius));
        if (nearEntities.isEmpty()) {
            return;
        }
        nearEntities.forEach(entityConsumer);
    }

    public static AABB getBoundingBoxAroundPlayer(Vec3 playerPos, int radius, int yRadius) {
        return new AABB(playerPos.m_7096_() - (double)radius, playerPos.m_7098_() - (double)yRadius, playerPos.m_7094_() - (double)radius, playerPos.m_7096_() + (double)radius, playerPos.m_7098_() + (double)yRadius + 1.0, playerPos.m_7094_() + (double)radius);
    }

    public static Vec3 moveVector(Vec3 playerPos, Vec3 itemPos) {
        return playerPos.m_82546_(itemPos).m_82541_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void chopDownTree(Player player, BlockPos pos, BlockState state, ItemStack itemStack) {
        try {
            processedBlocks2.add(pos);
            Level world = player.m_9236_();
            if (pos == null || state == null || itemStack == null || !(state.m_60734_() instanceof RotatedPillarBlock)) {
                return;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                serverPlayer.f_8941_.m_9280_(pos);
            }
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 1, 1)).forEach(bp -> {
                BlockState bs;
                if (!processedBlocks2.contains(bp) && (bs = world.m_8055_(bp)).m_60734_() instanceof RotatedPillarBlock) {
                    PU.chopDownTree(player, bp, bs, itemStack);
                }
            });
        }
        finally {
            processedBlocks2.remove(pos);
        }
    }

    public static ItemStack randomEnchantedBook() {
        Collection enchs = ForgeRegistries.ENCHANTMENTS.getValues();
        int num2 = (int)PU.generateRandomNumberBetween(0.0, enchs.size());
        ItemStack book = new ItemStack(() -> Items.f_42690_);
        HashMap<Enchantment, Integer> enchant = new HashMap<Enchantment, Integer>();
        enchant.put((Enchantment)enchs.stream().toList().get(num2), new Random().nextInt(((Enchantment)enchs.stream().toList().get(num2)).m_6586_()) + 1);
        EnchantmentHelper.m_44865_(enchant, (ItemStack)book);
        return book;
    }

    public static class AttributeHelper {
        public static OptionalPair<AttributeInstance, Double> getPlayerCurrentAttribute(@Nonnull LivingEntity e, Attribute a) {
            return new OptionalPair<AttributeInstance, Double>(e.m_21051_(a), e.m_21051_(a) == null ? 0.0 : Objects.requireNonNull(e.m_21051_(a)).m_22135_());
        }

        public static void applyModifier(@Nonnull LivingEntity e, Attribute a, AttributeModifier modifier) {
            OptionalPair<AttributeInstance, Double> optAttributeInstance = AttributeHelper.getPlayerCurrentAttribute(e, a);
            optAttributeInstance.getFirst().ifPresent(player -> Optional.ofNullable(player.m_22111_(modifier.m_22209_())).ifPresentOrElse(pl -> AttributeHelper.updateAttribute(e, a, modifier), () -> player.m_22118_(new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), (Double)optAttributeInstance.secondData() + modifier.m_22218_(), modifier.m_22217_()))));
        }

        public static void removeModifier(@Nonnull LivingEntity e, Attribute a, AttributeModifier modifier) {
            AttributeHelper.getPlayerCurrentAttribute(e, a).getFirst().ifPresent(player -> player.m_22130_(modifier));
        }

        private static void updateAttribute(@Nonnull LivingEntity e, Attribute a, AttributeModifier modifier) {
            AttributeHelper.getPlayerCurrentAttribute(e, a).getFirst().ifPresent(attributeInstance -> {
                double modifierValue;
                if (attributeInstance.m_22109_(modifier) && (modifierValue = e.m_21204_().m_22173_(a, modifier.m_22209_())) != modifier.m_22218_()) {
                    attributeInstance.m_22130_(modifier);
                    attributeInstance.m_22118_(new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), AttributeHelper.getPlayerCurrentAttribute(e, a).secondData() + modifier.m_22218_(), modifier.m_22217_()));
                }
            });
        }

        public static void reapplyAll(ItemStack itemStack, Attribute attribute, AttributeModifier modifier, EquipmentSlot modifierSlot) {
            if (itemStack.m_41782_()) {
                assert (itemStack.m_41783_() != null);
                if (!itemStack.m_41783_().m_128425_("AttributeModifiers", 9)) {
                    for (Map.Entry entry : itemStack.m_41638_(modifierSlot).entries()) {
                        Attribute attributeToReapply = (Attribute)entry.getKey();
                        AttributeModifier modifierToReapply = (AttributeModifier)entry.getValue();
                        if (attributeToReapply.equals(attribute)) continue;
                        AttributeModifier newModifier = new AttributeModifier(modifierToReapply.m_22209_(), modifierToReapply.m_22214_(), modifierToReapply.m_22218_(), modifierToReapply.m_22217_());
                        itemStack.m_41643_(attributeToReapply, newModifier, modifierSlot);
                    }
                }
            }
            itemStack.m_41643_(attribute, modifier, modifierSlot);
        }
    }

    public static class HotbarHelper {
        public static void setHotbarSlot(Player player, int slot, ItemStack stack) {
            IItemHandlerModifiable hotbar = (IItemHandlerModifiable)player.m_150109_();
            hotbar.setStackInSlot(slot, stack);
        }

        public static ItemStack getHotbarSlot(Player player, int slot) {
            IItemHandlerModifiable hotbar = (IItemHandlerModifiable)player.m_150109_();
            return hotbar.getStackInSlot(slot);
        }

        public static ItemStack getSelectedItem(Player player) {
            return player.m_150109_().m_36056_();
        }

        public static void setItemSelected(Player player, ItemStack slot) {
            player.m_150109_().m_36012_(slot);
        }
    }

    public static class InventoryHelper {
        public static void addItemToInventory(Player player, ItemStack stack) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }

        public static int getItemCount(Player player, Item item) {
            int count = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || stack.m_41720_() != item) continue;
                count += stack.m_41613_();
            }
            return count;
        }

        public static boolean removeItems(Player player, Item item, int count) {
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_() - 4; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() != item) continue;
                int stackCount = stack.m_41613_();
                if (stackCount >= count) {
                    stack.m_41764_(stackCount - count);
                    return true;
                }
                inventory.m_6836_(i, ItemStack.f_41583_);
                count -= stackCount;
            }
            return false;
        }

        public static int canAdd(Inventory inventory, ItemStack stack) {
            int i = inventory.m_36050_(stack);
            if (i == -1) {
                i = inventory.m_36062_();
            }
            return i;
        }

        public static boolean hasItems(Player player, Item item) {
            return player.m_150109_().f_35974_.stream().anyMatch(itemStack -> !itemStack.m_41619_() && itemStack.m_41720_() == item);
        }

        public static int getTotalItemCount(Player player) {
            return player.m_150109_().f_35974_.stream().filter(stack -> !stack.m_41619_()).mapToInt(ItemStack::m_41613_).sum();
        }
    }

    public static class BlockUtil {
        private final Level level;

        public BlockUtil(Level world) {
            this.level = world;
        }

        public boolean isBlockSolid(BlockPos pos) {
            return !this.level.m_8055_(pos).m_60795_();
        }

        public boolean isBlockType(BlockPos pos, Block block) {
            BlockState state = this.level.m_8055_(pos);
            return state.m_60734_() == block;
        }

        public BlockPos[] findBlocksInRange(BlockPos center, int radius, Block block) {
            int minX = (int)Math.floor(center.m_123341_()) - radius;
            int minY = (int)Math.floor(center.m_123342_()) - radius;
            int minZ = (int)Math.floor(center.m_123343_()) - radius;
            int maxX = (int)Math.floor(center.m_123341_()) + radius;
            int maxY = (int)Math.floor(center.m_123342_()) + radius;
            int maxZ = (int)Math.floor(center.m_123343_()) + radius;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        mutablePos.m_122178_(x, y, z);
                        if (!this.isBlockType((BlockPos)mutablePos, block)) continue;
                        builder.add((Object)mutablePos.m_7949_());
                    }
                }
            }
            return (BlockPos[])builder.build().toArray((Object[])new BlockPos[0]);
        }

        public double getDistance(BlockPos pos1, BlockPos pos2) {
            return pos1.m_123331_(new Vec3i(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_()));
        }

        public BlockPos getRandomBlockPos(BlockPos center, int range) {
            int x = center.m_123341_() + this.level.f_46441_.m_188503_(range * 2 + 1) - range;
            int y = center.m_123342_() + this.level.f_46441_.m_188503_(range * 2 + 1) - range;
            int z = center.m_123343_() + this.level.f_46441_.m_188503_(range * 2 + 1) - range;
            return new BlockPos(x, y, z);
        }
    }

    public static class OptionalPair<T, U> {
        private final Optional<T> first;
        private final Optional<U> second;

        public OptionalPair() {
            this.first = Optional.empty();
            this.second = Optional.empty();
        }

        public OptionalPair(T f, U s) {
            this.first = Optional.ofNullable(f);
            this.second = Optional.ofNullable(s);
        }

        public Optional<T> getFirst() {
            return this.first;
        }

        @Nullable
        public T firstData() {
            return this.first.get();
        }

        public Optional<U> getSecond() {
            return this.second;
        }

        @Nullable
        public U secondData() {
            return this.second.get();
        }
    }
}

