/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.util;

import java.util.List;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.util.EnchantUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randomenchants2", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        List tooltip = event.getToolTip();
        if (EnchantUtils.hasEnch(event.getItemStack(), (Enchantment)ModEnchantments.STONE_BOUND.get())) {
            ItemStack stack = player.m_21205_();
            if (event.getItemStack() != stack) {
                return;
            }
            tooltip.add(Component.m_237113_((String)("Mining Bonus: " + ChatFormatting.GREEN + "+" + (double)stack.m_41773_() * 0.02)));
            tooltip.add(Component.m_237113_((String)("Damage Penalty: " + ChatFormatting.RED + "-" + (double)stack.m_41773_() * 0.02)));
        } else if (EnchantUtils.hasEnch((LivingEntity)player, (Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get())) {
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            if (event.getItemStack() != chest) {
                return;
            }
            tooltip.add(Component.m_237113_((String)("Teleportation Range: " + ChatFormatting.AQUA + EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get()), (ItemStack)chest) * 10 + " blocks")));
            tooltip.add(Component.m_237113_((String)("Shuffle Cooldown: " + ChatFormatting.GOLD + (16 - EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get()), (ItemStack)chest) * EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get()), (ItemStack)chest)) + " seconds")));
        } else if (EnchantUtils.hasEnch((LivingEntity)player, (Enchantment)ModEnchantments.ETHEREAL_EMBRACE.get())) {
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            double eLevel = (double)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ETHEREAL_EMBRACE.get()), (ItemStack)chest) * 0.05;
            if (event.getItemStack() != chest) {
                return;
            }
            tooltip.add(Component.m_237113_((String)("Chance of phasing through attacks: " + ChatFormatting.BLUE + eLevel)));
        } else if (EnchantUtils.hasEnch((LivingEntity)player, (Enchantment)ModEnchantments.EXPLODING.get())) {
            ItemStack heldItem = player.m_21205_();
            float explosionSize = 1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.EXPLODING.get()), (ItemStack)heldItem);
            if (event.getItemStack() != heldItem) {
                return;
            }
            tooltip.add(Component.m_237113_((String)("Explosion Size: " + ChatFormatting.DARK_RED + explosionSize)));
        } else if (EnchantUtils.hasEnch((LivingEntity)player, (Enchantment)ModEnchantments.DUNGEONEERING.get())) {
            ItemStack heldItem = player.m_21205_();
            if (event.getItemStack() != heldItem) {
                return;
            }
            if (ModConfig.ServerConfig.dungeoneeringLootTableConfig.get() == ModConfig.Restriction2.ENABLED) {
                tooltip.add(Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + "Getting loot from 4 different dungeons")));
            } else if (ModConfig.ServerConfig.dungeoneeringLootTableConfig.get() == ModConfig.Restriction2.DISABLED) {
                tooltip.add(Component.m_237113_((String)(ChatFormatting.DARK_AQUA + "Getting loot from 1 dungeon")));
            }
        }
    }
}

