/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class Snatching
extends Enchantment {
    private static final List<EquipmentSlot> ARMOR_SLOTS = new ArrayList<EquipmentSlot>();

    public Snatching(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 30;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return ModConfig.ServerConfig.snatchingConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.snatchingConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.snatchingConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.snatchingConfig.get() == ModConfig.Restriction.TREASURE;
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof FishingRodItem && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.SNATCHING.get()), (ItemStack)heldItem) > 0) {
            if (player.f_36083_ == null || player.m_20193_().f_46443_) {
                return;
            }
            Entity hookedEntity = player.f_36083_.m_37170_();
            if (!(hookedEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity victim = (LivingEntity)hookedEntity;
            List<ItemStack> armorPieces = Snatching.removeArmor(victim);
            if (!armorPieces.isEmpty()) {
                Level world = player.m_9236_();
                BlockPos dropPos = victim.m_20183_();
                Random random = (Random)world.f_46441_;
                for (ItemStack armorPiece : armorPieces) {
                    ItemEntity entityItem = new ItemEntity(world, (double)dropPos.m_123341_(), (double)dropPos.m_123342_(), (double)dropPos.m_123343_(), armorPiece);
                    Vec3 velocityVector = victim.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(0.5 + random.nextDouble());
                    entityItem.m_20256_(velocityVector);
                    world.m_7967_((Entity)entityItem);
                }
            }
        }
    }

    public static List<ItemStack> removeArmor(LivingEntity victim) {
        ArrayList<ItemStack> armorPieces = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armorPiece;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorPiece = victim.m_6844_(slot)).m_41619_() || !armorPiece.m_41763_()) continue;
            armorPieces.add(armorPiece.m_41777_());
            victim.m_8061_(EquipmentSlot.MAINHAND, armorPiece.m_41777_());
            victim.m_8061_(slot, ItemStack.f_41583_);
            break;
        }
        return armorPieces;
    }

    static {
        ARMOR_SLOTS.add(EquipmentSlot.HEAD);
        ARMOR_SLOTS.add(EquipmentSlot.CHEST);
        ARMOR_SLOTS.add(EquipmentSlot.LEGS);
        ARMOR_SLOTS.add(EquipmentSlot.FEET);
    }
}

