/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.HashMap;
import java.util.Map;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.enchantment.Teleportation;
import net.hir0shiyt.randomenchants2.enchantment.Torches;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class Ricochet
extends Enchantment {
    private static final Map<AbstractArrow, Long> lastCollitionTime = new HashMap<AbstractArrow, Long>();

    public Ricochet(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 25;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return ModConfig.ServerConfig.ricochetConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.ricochetConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.ricochetConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.ricochetConfig.get() == ModConfig.Restriction.TREASURE;
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof Torches) && !(enchantment instanceof Teleportation) && super.m_5975_(enchantment);
    }

    @SubscribeEvent
    public static void arrowHit(ProjectileImpactEvent event) {
        HitResult result = event.getRayTraceResult();
        if (!(result instanceof BlockHitResult)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity shooter = arrow.m_19749_();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        ItemStack heldItem = player.m_21205_();
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RICOCHET.get()), (ItemStack)heldItem) > 0) {
            Direction facing = ((BlockHitResult)event.getRayTraceResult()).m_82434_();
            if (!lastCollitionTime.containsKey(arrow)) {
                lastCollitionTime.put(arrow, System.currentTimeMillis());
            } else {
                long lastCollition;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (lastCollition = lastCollitionTime.get(arrow).longValue()) >= 10000L) {
                    arrow.m_142687_(Entity.RemovalReason.DISCARDED);
                    lastCollitionTime.remove(arrow);
                    return;
                }
            }
            double x = arrow.m_20184_().m_7096_();
            double y = arrow.m_20184_().m_7098_();
            double z = arrow.m_20184_().m_7094_();
            Vec3 arrowMotion = arrow.m_20184_();
            switch (facing) {
                case UP: 
                case DOWN: {
                    arrowMotion = new Vec3(arrowMotion.f_82479_, -arrowMotion.f_82480_, arrowMotion.f_82481_);
                    break;
                }
                case EAST: 
                case WEST: {
                    arrowMotion = new Vec3(-arrowMotion.f_82479_, arrowMotion.f_82480_, arrowMotion.f_82481_);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    arrowMotion = new Vec3(arrowMotion.f_82479_, arrowMotion.f_82480_, -arrowMotion.f_82481_);
                    break;
                }
                default: {
                    throw new IllegalStateException("INVALID ENUM DETECTED" + facing);
                }
            }
            lastCollitionTime.put(arrow, System.currentTimeMillis());
            arrow.m_20256_(arrowMotion);
            event.setCanceled(true);
        }
    }
}

