/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.Magnetic;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.enchantment.SolarEnchant;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class Randomness
extends Enchantment {
    public Randomness(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 5 + 10 * (level - 1);
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return ModConfig.ServerConfig.randomnessConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.randomnessConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.randomnessConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.randomnessConfig.get() == ModConfig.Restriction.TREASURE;
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof SolarEnchant) && !(enchantment instanceof Magnetic) && super.m_5975_(enchantment);
    }

    public static Enchantment getRandomnessEnchant() {
        return (Enchantment)ModEnchantments.RANDOMNESS.get();
    }

    public static List<ItemStack> getRandomItems(Random random, int level) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.addAll(Randomness.getNormalBlockItems(random, level));
        drops.addAll(Randomness.getRandomEnchantmentItems(random, level));
        return drops;
    }

    private static List<ItemStack> getNormalBlockItems(Random random, int level) {
        return new ArrayList<ItemStack>();
    }

    private static List<ItemStack> getRandomEnchantmentItems(Random random, int level) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < level; ++i) {
            Item randomItem = Randomness.getRandomItem(random);
            if (randomItem == null) continue;
            int randomCount = 1 + random.nextInt(level);
            ItemStack drop = new ItemStack((ItemLike)randomItem, randomCount);
            drops.add(drop);
        }
        return drops;
    }

    private static Item getRandomItem(Random random) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : ForgeRegistries.ITEMS) {
            items.add(item);
        }
        return items.isEmpty() ? null : (Item)items.get(random.nextInt(items.size()));
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)Randomness.getRandomnessEnchant(), (ItemStack)stack);
        if (level <= 0 || event.getLevel().m_5776_()) {
            return;
        }
        System.out.println("Randomness Enchantment Level: " + level);
        Level world = (Level)event.getLevel();
        event.setCanceled(true);
        world.m_46961_(event.getPos(), false);
        event.setExpToDrop(0);
        List<ItemStack> drops = Randomness.getRandomItems(new Random(), level);
        for (ItemStack drop : drops) {
            if (drop.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
        }
    }
}

