/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.util.EnchantUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class Lumberjack
extends Enchantment {
    public Lumberjack(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 15;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return ModConfig.ServerConfig.lumberjackConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.lumberjackConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.lumberjackConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.lumberjackConfig.get() == ModConfig.Restriction.TREASURE;
    }

    @SubscribeEvent
    public static void onWoodBreak(BlockEvent.BreakEvent e) {
        Player p = e.getPlayer();
        if (!EnchantUtils.hasEnch((LivingEntity)p, (Enchantment)ModEnchantments.LUMBERJACK.get())) {
            return;
        }
        ItemStack stack = p.m_21205_();
        BlockState state = e.getState();
        Block block = state.m_60734_();
        BlockPos pos = e.getPos();
        int maxLogsToBreak = 64;
        int maxLogsDetected = 64;
        if (Lumberjack.isLog(block)) {
            ArrayList<BlockPos> logsToBreak = new ArrayList<BlockPos>();
            int logsFound = Lumberjack.findConnectedLogs(logsToBreak, e.getPlayer().m_20193_(), pos, maxLogsToBreak);
            int logsToBreakCount = Math.min(logsFound, maxLogsDetected);
            int damageAmount = logsToBreakCount / 2;
            stack.m_41622_(damageAmount, (LivingEntity)p, player -> {});
            for (BlockPos logPos : logsToBreak) {
                e.getPlayer().m_20193_().m_46961_(logPos, true);
            }
        }
    }

    private static boolean isLog(Block block) {
        ResourceLocation registryName = block.m_60589_();
        String namespace = registryName.m_135827_();
        return namespace.equals("minecraft") && registryName.m_135815_().contains("log");
    }

    private static int findConnectedLogs(List<BlockPos> logsToBreak, Level world, BlockPos start, int maxLogsDetected) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        int logsFound = 0;
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty() && logsFound < maxLogsDetected) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (!Lumberjack.isLog(world.m_8055_(currentPos).m_60734_())) continue;
            logsToBreak.add(currentPos);
            ++logsFound;
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = currentPos.m_121945_(direction);
                if (visited.contains(neighborPos)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
        return logsFound;
    }
}

