/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.List;
import javax.annotation.Nonnull;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.enchantment.Teleportation;
import net.hir0shiyt.randomenchants2.enchantment.Torches;
import net.hir0shiyt.randomenchants2.enchantment.Transposition;
import net.hir0shiyt.randomenchants2.enchantment.TrueShot;
import net.hir0shiyt.randomenchants2.util.EnchantUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.MultiShotEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class Homing
extends Enchantment {
    public Homing(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 15;
    }

    public int m_6586_() {
        return super.m_6586_();
    }

    public boolean m_6081_(@Nonnull ItemStack stack) {
        return ModConfig.ServerConfig.homingConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.homingConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.homingConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.homingConfig.get() == ModConfig.Restriction.TREASURE;
    }

    protected boolean m_5975_(@NotNull Enchantment enchantment) {
        return !(enchantment instanceof MultiShotEnchantment) && !(enchantment instanceof Torches) && !(enchantment instanceof Transposition) && !(enchantment instanceof Teleportation) && !(enchantment instanceof TrueShot) && super.m_5975_(enchantment);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Player player;
        ItemStack heldItem;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity = ((AbstractArrow)entity2).m_19749_()) instanceof Player && EnchantUtils.hasEnch(heldItem = (player = (Player)entity).m_21205_(), (Enchantment)ModEnchantments.HOMING.get())) {
            AbstractArrow arrow = (AbstractArrow)entity2;
            double arrowVelocity = arrow.m_20184_().m_82553_();
            Level level = arrow.m_9236_();
            Vec3 shooterPos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20236_(player.m_20089_()), player.m_20189_());
            List<LivingEntity> livingEntities = Homing.getLivingEntitiesInWorld(level, arrow.m_19749_());
            LivingEntity nearestEntity = null;
            double nearestDistanceSq = Double.MAX_VALUE;
            for (LivingEntity livingEntity : livingEntities) {
                double distanceSq = livingEntity.m_20238_(shooterPos);
                if (!(distanceSq < nearestDistanceSq)) continue;
                nearestEntity = livingEntity;
                nearestDistanceSq = distanceSq;
            }
            if (nearestEntity == null || nearestEntity instanceof Animal) {
                return;
            }
            double targetY = nearestEntity.m_20186_() + (double)nearestEntity.m_20206_() / 2.0;
            double yOffSet = (double)nearestEntity.m_20206_() < 0.5 ? (double)nearestEntity.m_20206_() : 0.5;
            Vec3 targetPos = new Vec3(nearestEntity.m_20185_(), targetY - yOffSet, nearestEntity.m_20189_());
            Vec3 shootVec = targetPos.m_82546_(shooterPos).m_82541_().m_82490_(arrowVelocity);
            arrow.m_6034_(shooterPos.f_82479_, shooterPos.f_82480_ + (double)arrow.m_19749_().m_20192_(), shooterPos.f_82481_);
            arrow.m_20334_(shootVec.f_82479_, shootVec.f_82480_, shootVec.f_82481_);
            double deltaX = targetPos.f_82479_ - shooterPos.f_82479_;
            double deltaY = targetPos.f_82480_ - shooterPos.f_82480_;
            double deltaZ = targetPos.f_82481_ - shooterPos.f_82481_;
            double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            float yaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(deltaY, horizontalDistance) * 57.29577951308232));
            arrow.m_146922_(yaw);
            arrow.m_146926_(pitch);
            arrow.getPersistentData().m_128379_("randomenchants2:homing", true);
        }
    }

    private static List<LivingEntity> getLivingEntitiesInWorld(Level level, Entity shooter) {
        AABB boundingBox = shooter.m_20191_().m_82400_(22.0);
        return level.m_6443_(LivingEntity.class, boundingBox, entity -> entity != shooter);
    }
}

