/*
 * Decompiled with CFR 0.152.
 */
package net.hir0shiyt.randomenchants2.enchantment;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.hir0shiyt.randomenchants2.config.ModConfig;
import net.hir0shiyt.randomenchants2.enchantment.ModEnchantments;
import net.hir0shiyt.randomenchants2.util.EnchantUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="randomenchants2")
public class DimensionalShuffle
extends Enchantment {
    private static final Map<ItemStack, Integer> itemCooldown = new HashMap<ItemStack, Integer>();
    private static final Random RANDOM = new Random();

    public DimensionalShuffle(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    public int m_6183_(int level) {
        return 15 + level * 2;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6081_(ItemStack stack) {
        return ModConfig.ServerConfig.dimensionalShuffleConfig.get() != ModConfig.Restriction.DISABLED && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ModConfig.ServerConfig.dimensionalShuffleConfig.get() != ModConfig.Restriction.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return ModConfig.ServerConfig.dimensionalShuffleConfig.get() == ModConfig.Restriction.ENABLED;
    }

    public boolean m_6591_() {
        return ModConfig.ServerConfig.dimensionalShuffleConfig.get() == ModConfig.Restriction.TREASURE;
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        Player player;
        ItemStack armor;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && EnchantUtils.hasEnch(armor = (player = (Player)entity).m_6844_(EquipmentSlot.CHEST), (Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get())) {
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.DIMENSIONAL_SHUFFLE.get()), (ItemStack)armor);
            if ((!itemCooldown.containsKey(armor) || itemCooldown.get(armor) <= 0) && level > 0 && player.m_21223_() - event.getAmount() <= 0.0f) {
                event.setCanceled(true);
                DimensionalShuffle.teleportPlayerRandomly(player, level);
                int cooldown = 320 - level * level;
                itemCooldown.put(armor, cooldown);
            }
        }
    }

    private static void teleportPlayerRandomly(Player player, int level) {
        Level world = player.m_20193_();
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        double radius = level * 10;
        BlockPos targetPos = null;
        for (int i = 0; i < 10; ++i) {
            double newZ;
            double newY;
            double newX = x + (RANDOM.nextDouble() - 0.5) * radius;
            BlockPos candidatePos = new BlockPos((int)newX, (int)(newY = y + (RANDOM.nextDouble() - 0.5) * radius), (int)(newZ = z + (RANDOM.nextDouble() - 0.5) * radius));
            if (!world.m_46749_(candidatePos)) continue;
            BlockState candidateBlock = world.m_8055_(candidatePos);
            while (candidateBlock.m_60795_()) {
                candidatePos = candidatePos.m_7495_();
                candidateBlock = world.m_8055_(candidatePos);
            }
            if (world.m_46855_(player.m_6921_())) continue;
            targetPos = candidatePos;
            break;
        }
        if (targetPos != null) {
            double adjustedX = (double)targetPos.m_123341_() + 0.5;
            double adjustedY = (double)targetPos.m_123342_() + 2.0;
            double adjustedZ = (double)targetPos.m_123343_() + 0.5;
            player.m_6021_(adjustedX, adjustedY, adjustedZ);
        }
    }
}

