/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.DamageParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.particle.type.HealParticle;
import org.joml.Vector3f;

public class EntityState {
    protected final LivingEntity entity;
    protected Set<ResourceLocation> effects;
    protected float currentHealth;
    protected float lastHealth;
    protected float lastTransitionHealth;
    protected long lastTransitionTime;
    protected DamageSource lastDamageSource;

    public EntityState(LivingEntity entity) {
        this.entity = entity;
        this.lastHealth = this.currentHealth = entity.m_21223_();
        TESConstants.NETWORKING.requestEffectsSync(this.entity.m_19879_());
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public float getHealth() {
        return this.currentHealth;
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastTransitionHealth() {
        return this.lastTransitionHealth;
    }

    public float getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Set<ResourceLocation> getEffects() {
        return this.effects == null ? Set.of() : this.effects;
    }

    public void modifyEffects(Set<ResourceLocation> ids, Set<ResourceLocation> idsToRemove) {
        if (this.effects == null) {
            this.effects = new ObjectOpenHashSet(ids);
        } else {
            this.effects.addAll(ids);
        }
        this.effects.removeAll(idsToRemove);
    }

    public boolean isValid() {
        return this.entity != null && this.entity.m_6084_() && this.entity.m_9236_() == Minecraft.m_91087_().f_91073_;
    }

    public void tick() {
        this.currentHealth = Math.min(this.entity.m_21223_(), this.entity.m_21233_());
        if (this.currentHealth != this.lastHealth && this.entity.f_19797_ > 2) {
            this.handleHealthChange();
            this.lastDamageSource = this.entity.m_21225_();
        }
        this.lastHealth = this.currentHealth;
        if (this.entity.m_9236_().m_46467_() - this.lastTransitionTime > 20L) {
            if (this.lastTransitionHealth > this.currentHealth) {
                this.lastTransitionHealth -= this.entity.m_21233_() / 30.0f;
            } else {
                this.lastTransitionTime = 0L;
                this.lastTransitionHealth = this.currentHealth;
            }
        }
    }

    protected void handleHealthChange() {
        if (TESAPI.getConfig().particlesEnabled()) {
            GenericTESParticle particle;
            boolean damageSourceAccurate;
            float healthDelta = this.currentHealth - this.lastHealth;
            boolean bl = damageSourceAccurate = this.entity.m_21225_() != null && this.lastDamageSource != this.entity.m_21225_();
            if (healthDelta != 0.0f) {
                healthDelta = TESParticleManager.handleParticleClaims(this, healthDelta, TESParticleManager::addParticle, damageSourceAccurate);
            }
            if (healthDelta == 0.0f) {
                return;
            }
            Vector3f particlePos = new Vector3f((float)this.entity.m_20185_(), (float)this.entity.m_20188_(), (float)this.entity.m_20189_());
            if (healthDelta < 0.0f) {
                LivingEntity attacker;
                int teamColour;
                Entity entity;
                this.lastTransitionTime = this.entity.m_9236_().m_46467_();
                int colour = TESAPI.getConfig().getDamageParticleColour();
                if (this.lastTransitionHealth == 0.0f) {
                    this.lastTransitionHealth = this.lastHealth;
                }
                if (damageSourceAccurate && TESAPI.getConfig().teamBasedDamageParticleColours() && (entity = this.entity.m_21225_().m_7639_()) instanceof LivingEntity && (teamColour = (attacker = (LivingEntity)entity).m_19876_()) != 0xFFFFFF) {
                    colour = teamColour;
                }
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth <= 0.0f && this.lastHealth >= this.entity.m_21233_() ? new ComponentParticle(this, particlePos, TESParticle.Animation.POP_OFF, (Component)Component.m_237115_((String)"config.tes.particle.verbal.instakill").m_6270_(Style.f_131099_.m_178520_(colour))) : new DamageParticle(this, particlePos, -healthDelta).withColour(colour);
            } else {
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth >= this.entity.m_21233_() && this.lastHealth <= this.entity.m_21233_() * 0.05f ? new ComponentParticle(this, particlePos, TESParticle.Animation.RISE, (Component)Component.m_237115_((String)"config.tes.particle.verbal.fullHeal").m_6270_(Style.f_131099_.m_178520_(TESAPI.getConfig().getHealParticleColour()))) : new HealParticle(this, particlePos, healthDelta);
            }
            TESParticleManager.addParticle(particle);
        }
    }
}

