/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)Util.m_137469_(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Armour", BuiltinHudElements::renderEntityArmour);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
    });
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static LivingEntity TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(LivingEntity entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = Minecraft.m_91087_().f_91073_.m_46467_() + 1L + (long)TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static LivingEntity getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void renderForHud(GuiGraphics guiGraphics, Minecraft mc, float partialTick) {
        if (TARGET_ENTITY == null) {
            return;
        }
        if (!TARGET_ENTITY.m_6084_() || TARGET_ENTITY.m_9236_() != mc.f_91073_ || mc.f_91073_.m_46467_() > TARGET_EXPIRY_TIME) {
            TARGET_ENTITY = null;
            return;
        }
        if (!TESAPI.getConfig().hudEnabled() || !TESAPI.getConfig().hudBossesEnabled() && TESConstants.UTILS.getEntityType(TARGET_ENTITY) == TESEntityType.BOSS) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().hudOpacity();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        TESAPI.getConfig().hudRenderPosition().adjustRenderForHudPosition(guiGraphics);
        RenderSystem.enableBlend();
        if (TESAPI.getConfig().hudEntityRender()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            TESClientUtil.renderEntityIcon(guiGraphics, mc, partialTick, TARGET_ENTITY, hudOpacity, true);
            poseStack.m_252880_(40.0f, 0.0f, 0.0f);
        }
        poseStack.m_252880_(0.0f, 2.0f, 0.0f);
        for (TESHudElement element : ELEMENTS.values()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
            int offset = element.render(guiGraphics, mc, partialTick, TARGET_ENTITY, hudOpacity, false);
            if (offset <= 0) continue;
            poseStack.m_252880_(0.0f, (float)(2 + offset), 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderInWorld(PoseStack poseStack, LivingEntity entity, float partialTick) {
        if (!TESAPI.getConfig().inWorldBarsEnabled() || entity.m_21224_() || entity.m_20199_().anyMatch(passenger -> passenger == Minecraft.m_91087_().f_91074_) && !TESAPI.getConfig().inWorldHudForSelf()) {
            return;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !TESAPI.getConfig().inWorldHUDActivation().test(entityState)) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().inWorldHudOpacity();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 position = entity.m_20318_(partialTick).m_82546_(mc.f_91063_.m_109153_().m_90583_()).m_82549_(mc.m_91290_().m_114382_((Entity)entity).m_7860_((Entity)entity, partialTick));
        poseStack.m_85836_();
        poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        poseStack.m_252880_(0.0f, entity.m_20206_() + 0.5f, 0.0f);
        poseStack.m_252880_(0.0f, TESConstants.CONFIG.inWorldHudManualVerticalOffset(), 0.0f);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(0.02f, 0.02f, 0.02f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        GuiGraphics guiGraphics = TESClientUtil.createInlineGuiGraphics(poseStack, mc.m_91269_().m_110104_());
        guiGraphics.m_280168_().m_85836_();
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(guiGraphics, mc, partialTick, entity, hudOpacity, true);
            if (offset <= 0) continue;
            guiGraphics.m_280168_().m_252880_(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        guiGraphics.m_280262_();
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void pickNewEntity(float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91076_ != null) {
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(mc.f_91076_);
            if (target != null && TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            AABB hitBounds;
            Vec3 cameraView;
            Vec3 rayEnd;
            Vec3 cameraPos;
            double targetingRange = TESAPI.getConfig().getHudTargetDistance();
            Entity cameraEntity = mc.m_91288_();
            EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)cameraEntity, (Vec3)(cameraPos = cameraEntity.m_20299_(partialTick)), (Vec3)(rayEnd = cameraPos.m_82549_((cameraView = cameraEntity.m_20252_(partialTick)).m_82542_(targetingRange, targetingRange, targetingRange))), (AABB)(hitBounds = cameraEntity.m_20191_().m_82369_(cameraView.m_82490_(targetingRange)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.m_82443_());
            if (target == null || !TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.m_82450_().m_82557_(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.m_82549_(cameraView.m_82542_(targetingRange, targetingRange, targetingRange));
            BlockHitResult blockHitResult = cameraEntity.m_9236_().m_45547_(new ClipContext(cameraPos, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cameraEntity));
            if (blockHitResult == null || blockHitResult.m_6662_() == HitResult.Type.MISS || blockHitResult.m_82450_().m_82557_(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        COMBINED;

    }
}

