/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.util.TESClientUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface TESParticle<D> {
    public void updateData(D var1);

    public void render(GuiGraphics var1, Minecraft var2, Font var3, float var4);

    public void tick(Minecraft var1);

    public boolean isValid();

    default public void defaultedTextRender(Minecraft mc, PoseStack poseStack, Vector3f prevPos, Vector3f pos, float partialTick, Runnable renderCallback) {
        float scale = 0.035f * TESAPI.getConfig().getParticleScale();
        Camera camera = mc.f_91063_.m_109153_();
        Vector3f renderPos = prevPos.lerp((Vector3fc)pos, partialTick, new Vector3f()).sub((Vector3fc)camera.m_90583_().m_252839_());
        poseStack.m_85836_();
        poseStack.m_252880_(renderPos.x, renderPos.y, renderPos.z);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        renderCallback.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public static abstract class Animation {
        public static final Animation POP_OFF = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                return new Vector3f((float)random.nextGaussian() * 0.03f + 0.025f, random.nextFloat() * 0.035f + 0.37f, (float)random.nextGaussian() * 0.03f + 0.025f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.05f, 0.0f);
                pos.add((Vector3fc)velocity);
            }
        };
        public static final Animation RISE = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                position.add((float)random.nextGaussian() * 0.05f, 0.4f, (float)random.nextGaussian() * 0.05f);
                return new Vector3f(0.0f, 0.2f, 0.0f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.02f, 0.0f);
                if (velocity.y() < 0.0f) {
                    velocity.mul(1.0f, 0.5f, 1.0f);
                }
                pos.add((Vector3fc)velocity);
            }
        };

        public abstract Vector3f getInitialVelocity(TESParticle<?> var1, Vector3f var2, Random var3);

        public abstract void perTickModifier(TESParticle<?> var1, int var2, Vector3f var3, Vector3f var4, Vector3f var5, Random var6);
    }
}

