/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.jade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public enum ChampionComponentProvider implements IEntityComponentProvider
{
    INSTANCE;


    private static Component getChampionName(Tuple<Integer, Integer> rank, IChampion champion) {
        return Component.m_237115_((String)("rank.champions.title." + rank.m_14418_())).m_130946_(" " + champion.getLivingEntity().m_7755_().getString()).m_130948_(Style.f_131099_.m_178520_(((Integer)rank.m_14419_()).intValue()));
    }

    private static Component getChampionDescription(IAffix affix) {
        return Component.m_237115_((String)("affix.champions." + affix.getIdentifier()));
    }

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        ChampionCapability.getCapability(entityAccessor.getEntity()).ifPresent(champion -> {
            champion.getClient().getRank().ifPresent(rank -> iTooltip.add(ChampionComponentProvider.getChampionName((Tuple<Integer, Integer>)rank, champion), Identifiers.CORE_OBJECT_NAME));
            List<IAffix> affixes = champion.getClient().getAffixes();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < affixes.size(); ++i) {
                line.append(ChampionComponentProvider.getChampionDescription(affixes.get(i)).getString());
                if ((i + 1) % ClientChampionsConfig.lineCount == 0 || i == affixes.size() - 1) {
                    components.add(Component.m_237113_((String)line.toString()));
                    line.setLength(0);
                    continue;
                }
                line.append(" ");
            }
            iTooltip.addAll(components);
        });
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("champions", "enable_affix_compact");
    }
}

