/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.util;

import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.math.vec.Vec3f;
import com.mr_toad.lib.mtjava.math.vec.Vec3i;
import com.mr_toad.lib.mtjava.math.vec.Vec4f;
import com.mr_toad.lib.mtjava.math.vec.Vec4i;
import java.util.Arrays;
import java.util.function.IntSupplier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SimpleARGB
implements IntSupplier,
Comparable<SimpleARGB> {
    public static final SimpleARGB WHITE = new SimpleARGB(1.0f);
    public static final SimpleARGB BLACK = new SimpleARGB(0.0f);
    private int a;
    private int r;
    private int g;
    private int b;

    public SimpleARGB(int color) {
        this.a = color >> 24 & 0xFF;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
    }

    public SimpleARGB(Vec3f vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public SimpleARGB(Vec3i vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public SimpleARGB(Vec4f vec) {
        this(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public SimpleARGB(Vec4i vec) {
        this(vec.x(), vec.y(), vec.z(), vec.w());
    }

    public SimpleARGB(SimpleARGB argb) {
        this.a = argb.alpha();
        this.r = argb.red();
        this.g = argb.green();
        this.b = argb.blue();
    }

    public SimpleARGB(float v) {
        this(v, v, v, v);
    }

    public SimpleARGB(float r, float g, float b) {
        this(1.0f, r, g, b);
        MtJava.validatePercents(r, g, b);
    }

    public SimpleARGB(int r, int g, int b) {
        this(255, r, g, b);
    }

    public SimpleARGB(float a, float r, float g, float b) {
        MtJava.validatePercents(a, r, g, b);
        this.a = Mth.m_14143_((float)Mth.m_14036_((float)(a * 255.0f), (float)0.0f, (float)255.0f));
        this.r = Mth.m_14143_((float)Mth.m_14036_((float)(r * 255.0f), (float)0.0f, (float)255.0f));
        this.g = Mth.m_14143_((float)Mth.m_14036_((float)(g * 255.0f), (float)0.0f, (float)255.0f));
        this.b = Mth.m_14143_((float)Mth.m_14036_((float)(b * 255.0f), (float)0.0f, (float)255.0f));
    }

    public SimpleARGB(int a, int r, int g, int b) {
        this.a = Mth.m_14045_((int)a, (int)0, (int)255);
        this.r = Mth.m_14045_((int)r, (int)0, (int)255);
        this.g = Mth.m_14045_((int)g, (int)0, (int)255);
        this.b = Mth.m_14045_((int)b, (int)0, (int)255);
    }

    @Override
    public int getAsInt() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public SimpleARGB set(SimpleARGB argb) {
        this.setA(argb.alpha());
        this.setR(argb.red());
        this.setG(argb.green());
        this.setB(argb.blue());
        return this;
    }

    public SimpleARGB set(float r, float g, float b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
        return this;
    }

    public SimpleARGB set(float a, float r, float g, float b) {
        this.setA(a);
        this.setR(r);
        this.setG(g);
        this.setB(b);
        return this;
    }

    public SimpleARGB set(int r, int g, int b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
        return this;
    }

    public SimpleARGB set(int a, int r, int g, int b) {
        this.setA(a);
        this.setR(r);
        this.setG(g);
        this.setB(b);
        return this;
    }

    public void lerp(float x, int a, int b) {
        this.setA(Mth.m_269140_((float)x, (int)(a >>> 24), (int)(b >>> 24)));
        this.setR(Mth.m_269140_((float)x, (int)(a << 16), (int)(b << 16)));
        this.setG(Mth.m_269140_((float)x, (int)(a << 8), (int)(a << 8)));
        this.setB(Mth.m_269140_((float)x, (int)a, (int)b));
    }

    public void lerp(float x, int a1, int a2, int r1, int r2, int g1, int g2, int b1, int b2) {
        this.setA(Mth.m_269140_((float)x, (int)a1, (int)a2));
        this.setR(Mth.m_269140_((float)x, (int)r1, (int)r2));
        this.setG(Mth.m_269140_((float)x, (int)g1, (int)g2));
        this.setB(Mth.m_269140_((float)x, (int)b1, (int)b2));
    }

    public void setA(float a) {
        MtJava.validatePercents((double)a);
        this.a = Mth.m_14143_((float)Mth.m_14036_((float)(a * 255.0f), (float)0.0f, (float)255.0f));
    }

    public void setR(float r) {
        MtJava.validatePercents((double)this.a);
        this.r = Mth.m_14143_((float)Mth.m_14036_((float)(r * 255.0f), (float)0.0f, (float)255.0f));
    }

    public void setG(float g) {
        MtJava.validatePercents((double)this.a);
        this.g = Mth.m_14143_((float)Mth.m_14036_((float)(g * 255.0f), (float)0.0f, (float)255.0f));
    }

    public void setB(float b) {
        MtJava.validatePercents((double)this.a);
        this.b = Mth.m_14143_((float)Mth.m_14036_((float)(b * 255.0f), (float)0.0f, (float)255.0f));
    }

    public void setA(int a) {
        this.a = Mth.m_14045_((int)a, (int)0, (int)255);
    }

    public void setR(int r) {
        this.r = Mth.m_14045_((int)r, (int)0, (int)255);
    }

    public void setG(int g) {
        this.g = Mth.m_14045_((int)g, (int)0, (int)255);
    }

    public void setB(int b) {
        this.b = Mth.m_14045_((int)b, (int)0, (int)255);
    }

    public float alphaFactor() {
        return (float)this.alpha() / 255.0f;
    }

    public float redFactor() {
        return (float)this.red() / 255.0f;
    }

    public float greenFactor() {
        return (float)this.green() / 255.0f;
    }

    public float blueFactor() {
        return (float)this.blue() / 255.0f;
    }

    public int alpha() {
        return this.a;
    }

    public int red() {
        return this.r;
    }

    public int green() {
        return this.g;
    }

    public int blue() {
        return this.b;
    }

    public int[] getColor() {
        return new int[]{this.alpha(), this.red(), this.green(), this.blue()};
    }

    public float[] getPercent() {
        return new float[]{this.alphaFactor(), this.redFactor(), this.greenFactor(), this.blueFactor()};
    }

    @Override
    public int compareTo(@NotNull SimpleARGB other) {
        return Integer.compare(this.getAsInt(), other.getAsInt());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleARGB) {
            SimpleARGB argb = (SimpleARGB)obj;
            return Arrays.equals(this.getColor(), argb.getColor());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getColor());
    }

    public String toString() {
        return "ARGB(" + String.join((CharSequence)", ", Arrays.stream(this.getColor()).mapToObj(String::valueOf).toList()) + ")";
    }
}

