/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mr_toad.lib.mtjava.nio.MTNIO;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;

public interface IntVec<S extends IntVec<S>> {
    public static <S extends IntVec<S>> S load(Supplier<S> empty, ListTag list) {
        IntVec vec = (IntVec)empty.get();
        List<IntTag> tags = list.stream().map(IntTag.class::cast).toList();
        for (int i = 0; i < tags.size(); ++i) {
            vec.set(i, tags.get(i).m_7047_());
        }
        return (S)vec;
    }

    public static <S extends IntVec<S>> S read(Supplier<S> empty, FriendlyByteBuf buf) {
        IntVec vec = (IntVec)empty.get();
        IntList ints = MTNIO.readIntList(buf);
        for (int i = 0; i < ints.size(); ++i) {
            vec.set(i, ints.getInt(i));
        }
        return (S)vec;
    }

    @CanIgnoreReturnValue
    public S set(S var1);

    @CanIgnoreReturnValue
    public S set(int var1, int var2);

    @CanIgnoreReturnValue
    public S set(int var1);

    @CanIgnoreReturnValue
    public S add(S var1);

    @CanIgnoreReturnValue
    public S sub(S var1);

    @CanIgnoreReturnValue
    public S mul(S var1);

    @CanIgnoreReturnValue
    public S div(S var1);

    @CanIgnoreReturnValue
    public S scale(int var1);

    @CanIgnoreReturnValue
    public S min(S var1);

    @CanIgnoreReturnValue
    public S max(S var1);

    @CanIgnoreReturnValue
    public S abs();

    @CanIgnoreReturnValue
    public S cross(S var1);

    public IntList values();

    public int length();

    public int lengthSqr();

    public int dist(S var1);

    public int distSqr(S var1);

    public int dot(S var1);

    public S zero();

    public S create();

    default public int get(int index) {
        return this.values().getInt(index);
    }

    default public int size() {
        return this.values().size();
    }

    @CanIgnoreReturnValue
    default public S destroy() {
        return this.set(this.zero());
    }

    @CanIgnoreReturnValue
    default public S inverse() {
        return this.scale(-1);
    }

    @CanIgnoreReturnValue
    default public S def(int scalar) {
        return this.scale(1 / scalar);
    }

    @CanIgnoreReturnValue
    default public S normalize() {
        return this.def(this.length());
    }

    default public void setIf(IntPredicate predicate, IntUnaryOperator v) {
        for (int i = 0; i < this.values().intStream().filter(predicate).toArray().length; ++i) {
            this.set(i, v.applyAsInt(this.get(i)));
        }
    }

    default public void setIf(IntPredicate predicate, int v) {
        for (int i = 0; i < this.values().intStream().filter(predicate).toArray().length; ++i) {
            this.set(i, v);
        }
    }

    default public boolean anyEqual(float v) {
        return this.values().intStream().anyMatch(d -> (float)d == v);
    }

    default public boolean allEqual(float v) {
        return this.values().intStream().allMatch(d -> (float)d == v);
    }

    default public boolean noneEqual(float v) {
        return this.values().intStream().noneMatch(d -> (float)d == v);
    }

    default public ListTag save() {
        ListTag list = new ListTag();
        IntListIterator intListIterator = this.values().iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            list.add((Object)IntTag.m_128679_((int)value));
        }
        return list;
    }

    default public void write(FriendlyByteBuf buf) {
        IntListIterator intListIterator = this.values().iterator();
        while (intListIterator.hasNext()) {
            int value = (Integer)intListIterator.next();
            buf.writeInt(value);
        }
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

