/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mr_toad.lib.mtjava.nio.MTNIO;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoublePredicate;
import it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;

public interface DoubleVec<S extends DoubleVec<S>> {
    public static <S extends DoubleVec<S>> S load(Supplier<S> empty, ListTag list) {
        DoubleVec vec = (DoubleVec)empty.get();
        List<DoubleTag> tags = list.stream().map(DoubleTag.class::cast).toList();
        for (int i = 0; i < tags.size(); ++i) {
            vec.set(i, tags.get(i).m_7061_());
        }
        return (S)vec;
    }

    public static <S extends DoubleVec<S>> S read(Supplier<S> empty, FriendlyByteBuf buf) {
        DoubleVec vec = (DoubleVec)empty.get();
        DoubleList list = MTNIO.readDoubleList(buf);
        for (int i = 0; i < list.size(); ++i) {
            vec.set(i, list.getDouble(i));
        }
        return (S)vec;
    }

    @CanIgnoreReturnValue
    public S set(S var1);

    @CanIgnoreReturnValue
    public S set(int var1, double var2);

    @CanIgnoreReturnValue
    public S set(double var1);

    @CanIgnoreReturnValue
    public S add(S var1);

    @CanIgnoreReturnValue
    public S sub(S var1);

    @CanIgnoreReturnValue
    public S mul(S var1);

    @CanIgnoreReturnValue
    public S div(S var1);

    @CanIgnoreReturnValue
    public S scale(double var1);

    @CanIgnoreReturnValue
    public S min(S var1);

    @CanIgnoreReturnValue
    public S max(S var1);

    @CanIgnoreReturnValue
    public S abs();

    @CanIgnoreReturnValue
    public S cross(S var1);

    public DoubleList values();

    public double length();

    public double lengthSqr();

    public double dist(S var1);

    public double distSqr(S var1);

    public double dot(S var1);

    public S zero();

    public S create();

    default public double get(int index) {
        return this.values().getDouble(index);
    }

    default public int size() {
        return this.values().size();
    }

    @CanIgnoreReturnValue
    default public S destroy() {
        return this.set(this.zero());
    }

    @CanIgnoreReturnValue
    default public S inverse() {
        return this.scale(-1.0);
    }

    @CanIgnoreReturnValue
    default public S def(double scalar) {
        return this.scale(1.0 / scalar);
    }

    @CanIgnoreReturnValue
    default public S normalize() {
        return this.def(this.length());
    }

    default public void setIf(DoublePredicate predicate, DoubleUnaryOperator v) {
        for (int i = 0; i < this.values().doubleStream().filter(arg_0 -> predicate.test(arg_0)).toArray().length; ++i) {
            this.set(i, v.apply(this.get(i)));
        }
    }

    default public void setIf(DoublePredicate predicate, double v) {
        for (int i = 0; i < this.values().doubleStream().filter(arg_0 -> predicate.test(arg_0)).toArray().length; ++i) {
            this.set(i, v);
        }
    }

    default public boolean anyEqual(float v) {
        return this.values().doubleStream().anyMatch(d -> d == (double)v);
    }

    default public boolean allEqual(float v) {
        return this.values().doubleStream().allMatch(d -> d == (double)v);
    }

    default public boolean noneEqual(float v) {
        return this.values().doubleStream().noneMatch(d -> d == (double)v);
    }

    default public ListTag save() {
        ListTag list = new ListTag();
        DoubleListIterator doubleListIterator = this.values().iterator();
        while (doubleListIterator.hasNext()) {
            double value = (Double)doubleListIterator.next();
            list.add((Object)DoubleTag.m_128500_((double)value));
        }
        return list;
    }

    default public void write(FriendlyByteBuf buf) {
        DoubleListIterator doubleListIterator = this.values().iterator();
        while (doubleListIterator.hasNext()) {
            double value = (Double)doubleListIterator.next();
            buf.writeDouble(value);
        }
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

