/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.util.Mth;
import org.joml.Vector2d;

public class Vec2d
implements DoubleVec<Vec2d> {
    public static final Vec2d ZERO = new Vec2d();
    private double x;
    private double y;

    public Vec2d() {
        this(0.0);
    }

    public Vec2d(List<Double> v) {
        this.x = v.get(0);
        this.y = v.get(1);
    }

    public Vec2d(DoubleVec<?> v) {
        this.x = v.get(0);
        this.y = v.get(1);
    }

    public Vec2d(double[] a) {
        this(a[0], a[1]);
    }

    public Vec2d(double v) {
        this(v, v);
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    @CanIgnoreReturnValue
    public Vec2d set(double x, double y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    @Override
    public Vec2d set(int index, double value) {
        switch (index) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
            }
        }
        return this;
    }

    @Override
    public Vec2d set(Vec2d other) {
        this.setX(other.x());
        this.setY(other.y());
        return this;
    }

    @Override
    public Vec2d set(double value) {
        this.setX(value);
        this.setY(value);
        return this;
    }

    @Override
    public Vec2d add(Vec2d other) {
        this.setX(this.x() + other.x());
        this.setY(this.y() + other.y());
        return this;
    }

    @Override
    public Vec2d sub(Vec2d other) {
        this.setX(this.x() - other.x());
        this.setY(this.y() - other.y());
        return this;
    }

    @Override
    public Vec2d mul(Vec2d other) {
        this.setX(this.x() * other.x());
        this.setY(this.y() * other.y());
        return this;
    }

    @Override
    public Vec2d div(Vec2d other) {
        this.setX(this.x() / other.x());
        this.setY(this.y() / other.y());
        return this;
    }

    @Override
    public Vec2d scale(double scalar) {
        this.setX(this.x() * scalar);
        this.setY(this.y() * scalar);
        return this;
    }

    @Override
    public Vec2d min(Vec2d other) {
        this.setX(Math.min(this.x(), other.x()));
        this.setY(Math.min(this.y(), other.y()));
        return this;
    }

    @Override
    public Vec2d max(Vec2d other) {
        this.setX(Math.max(this.x(), other.x()));
        this.setY(Math.max(this.y(), other.y()));
        return this;
    }

    @Override
    public Vec2d abs() {
        this.setX(Math.abs(this.x()));
        this.setY(Math.abs(this.y()));
        return this;
    }

    @Override
    public Vec2d cross(Vec2d other) {
        return new Vec2d(this.x() * other.y() - this.y() * other.x());
    }

    @Override
    public DoubleList values() {
        return DoubleList.of((double)this.x(), (double)this.y());
    }

    @Override
    public double length() {
        return Mth.m_184645_((double)this.x, (double)this.y);
    }

    @Override
    public double lengthSqr() {
        return Mth.m_211589_((double)this.x, (double)this.y);
    }

    @Override
    public double dist(Vec2d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        return Mth.m_184645_((double)x, (double)y);
    }

    @Override
    public double distSqr(Vec2d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        return Mth.m_211589_((double)x, (double)y);
    }

    @Override
    public double dot(Vec2d other) {
        return this.x() * other.x() + this.y() * other.y();
    }

    @Override
    public Vec2d zero() {
        return ZERO;
    }

    @Override
    public Vec2d create() {
        return new Vec2d();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec2d) {
            Vec2d other = (Vec2d)obj;
            return this.x() == other.x() && this.y() == other.y();
        }
        return false;
    }

    public int hashCode() {
        double prime = 31.0;
        double result = 1.0;
        result = prime * result + this.x();
        result = prime * result + this.y();
        return (int)result;
    }

    public String toString() {
        return this.name();
    }

    public Vector2d joml() {
        return new Vector2d(this.x(), this.y());
    }
}

