/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.interpolation;

import com.mr_toad.lib.api.helper.registry.SmallIdRegistry;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.mtjava.math.MtMath;
import com.mr_toad.lib.mtjava.math.interpolation.HermiteInterpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolation;
import com.mr_toad.lib.mtjava.math.interpolation.InterpolationContext;
import net.minecraft.util.Mth;

public class Interpolations {
    public static final SmallIdRegistry<Interpolation> INTERPOLATIONS = new SmallIdRegistry("toadlib.interpolations");
    public static final ValueHolder<Interpolation> CONST = INTERPOLATIONS.register(Interpolation.of("const", InterpolationContext::last));
    public static final ValueHolder<Interpolation> LINEAR = INTERPOLATIONS.register(Interpolation.of("linear", ctx -> ctx.lerp(ctx.x())));
    public static final ValueHolder<Interpolation> INV_LINEAR = INTERPOLATIONS.register(Interpolation.of("inv_linear", ctx -> ctx.invLerp(ctx.x())));
    public static final ValueHolder<Interpolation> QUAD_IN = INTERPOLATIONS.register(Interpolation.of("quad_in", ctx -> ctx.lerp(Mth.m_14207_((float)ctx.x()))));
    public static final ValueHolder<Interpolation> QUAD_OUT = INTERPOLATIONS.register(Interpolation.of("quad_out", ctx -> ctx.lerp(ctx.x() * (ctx.x() - 2.0f))));
    public static final ValueHolder<Interpolation> QUAD_INOUT = INTERPOLATIONS.register(Interpolation.of("quad_inout", ctx -> {
        float x2 = ctx.x() * 2.0f;
        if (x2 < 1.0f) {
            return ctx.lerp(0.5f * Mth.m_14207_((float)x2));
        }
        return ctx.lerp(0.5f * ((x2 -= 1.0f) * (x2 - 2.0f) - 1.0f));
    }));
    public static final ValueHolder<Interpolation> CUBIC_IN = INTERPOLATIONS.register(Interpolation.of("cubic_in", ctx -> ctx.lerp(MtMath.pow(ctx.x(), 3.0f))));
    public static final ValueHolder<Interpolation> CUBIC_OUT = INTERPOLATIONS.register(Interpolation.of("cubic_out", ctx -> ctx.lerp(MtMath.pow(ctx.x() - 1.0f, 3.0f) + 1.0f)));
    public static final ValueHolder<Interpolation> CUBIC_INOUT = INTERPOLATIONS.register(Interpolation.of("cubic_inout", ctx -> ctx.pow(3, 2.0f)));
    public static final ValueHolder<Interpolation> QUART_IN = INTERPOLATIONS.register(Interpolation.of("quart_in", ctx -> ctx.lerp(MtMath.pow(ctx.x(), 4.0f))));
    public static final ValueHolder<Interpolation> QUART_OUT = INTERPOLATIONS.register(Interpolation.of("quart_out", ctx -> ctx.lerp(MtMath.pow(ctx.x() - 1.0f, 4.0f) - 1.0f)));
    public static final ValueHolder<Interpolation> QUART_INOUT = INTERPOLATIONS.register(Interpolation.of("quart_inout", ctx -> ctx.pow(4, -2.0f)));
    public static final ValueHolder<Interpolation> QUINT_IN = INTERPOLATIONS.register(Interpolation.of("quint_in", ctx -> ctx.lerp(MtMath.pow(ctx.x(), 5.0f))));
    public static final ValueHolder<Interpolation> QUINT_OUT = INTERPOLATIONS.register(Interpolation.of("quint_out", ctx -> ctx.lerp(MtMath.pow(ctx.x() - 1.0f, 5.0f) - 1.0f)));
    public static final ValueHolder<Interpolation> QUINT_INOUT = INTERPOLATIONS.register(Interpolation.of("quint_inout", ctx -> ctx.pow(5, 2.0f)));
    public static final ValueHolder<Interpolation> EXP_IN = INTERPOLATIONS.register(Interpolation.of("exp_in", ctx -> ctx.x() == 0.0f ? ctx.last() : ctx.lerp(MtMath.pow((float)Math.E, 10.0f * ctx.x() - 10.0f))));
    public static final ValueHolder<Interpolation> EXP_OUT = INTERPOLATIONS.register(Interpolation.of("exp_out", ctx -> ctx.x() == 1.0f ? ctx.current() : ctx.lerp(1.0f - MtMath.pow((float)Math.E, -10.0f * ctx.x()))));
    public static final ValueHolder<Interpolation> EXP_INOUT = INTERPOLATIONS.register(Interpolation.of("exp_inout", ctx -> {
        float r = ctx.x() > 0.5f ? MtMath.pow((float)Math.E, 20.0f * ctx.x() - 10.0f) : 2.0f - MtMath.pow((float)Math.E, -20.0f * ctx.x() + 10.0f);
        return ctx.map(r / 2.0f);
    }));
    public static final ValueHolder<Interpolation> BACK_IN = INTERPOLATIONS.register(Interpolation.of("back_in", ctx -> ctx.lerp((float)Math.E * ctx.x() * ctx.x() * ctx.x() - 1.3591409f * ctx.x() * ctx.x())));
    public static final ValueHolder<Interpolation> BACK_OUT = INTERPOLATIONS.register(Interpolation.of("back_out", ctx -> ctx.lerp(1.0f + (float)Math.E * MtMath.pow(ctx.x() - 1.0f, 3.0f) + 1.3591409f * MtMath.pow(ctx.x() - 1.0f, 2.0f))));
    public static final ValueHolder<Interpolation> BACK_INOUT = INTERPOLATIONS.register(Interpolation.of("back_inout", ctx -> {
        float f = ctx.x() < 0.5f ? MtMath.pow(2.0f * ctx.x(), 2.0f) * (7.4365635f * ctx.x() - (float)Math.E) : MtMath.pow(2.0f * ctx.x() - 2.0f, 2.0f) * (3.7182817f * (ctx.x() * 2.0f - 2.0f) + (float)Math.E) + 2.0f;
        return ctx.lerp(f / 2.0f);
    }));
    public static final ValueHolder<Interpolation> ELASTIC_IN = INTERPOLATIONS.register(Interpolation.of("elastic_in", ctx -> ctx.map(-MtMath.pow(2.0f, 10.0f * ctx.x() - 10.0f) * Mth.m_14031_((float)((ctx.x() * 10.0f - 10.75f) * ((float)Math.PI * 2) / 3.0f)))));
    public static final ValueHolder<Interpolation> ELASTIC_OUT = INTERPOLATIONS.register(Interpolation.of("elastic_out", ctx -> ctx.map(MtMath.pow(2.0f, -10.0f * ctx.x()) * Mth.m_14031_((float)((ctx.x() * 10.0f - 0.75f) * ((float)Math.PI * 2) / 3.0f)) + 1.0f)));
    public static final ValueHolder<Interpolation> ELASTIC_INOUT = INTERPOLATIONS.register(Interpolation.of("elastic_inout", ctx -> {
        float f = 1.3962635f;
        float f1 = (20.0f * ctx.x() - 11.125f) * f;
        return ctx.map(ctx.x() < 0.5f ? -(MtMath.pow(2.0f, 20.0f * ctx.x() - 10.0f) * Mth.m_14031_((float)f1)) / 2.0f : MtMath.pow(2.0f, -20.0f * ctx.x() + 10.0f) * Mth.m_14031_((float)f1) / 2.0f + 1.0f);
    }));
    public static final ValueHolder<Interpolation> BOUNCE_IN = INTERPOLATIONS.register(Interpolation.of("bounce_in", ctx -> ctx.lerp(1.0f - Interpolations.bounce(1.0f - ctx.x(), 0.0f, 1.0f))));
    public static final ValueHolder<Interpolation> BOUNCE_OUT = INTERPOLATIONS.register(Interpolation.of("bounce_out", ctx -> Interpolations.bounce(ctx.x(), ctx.last(), ctx.current())));
    public static final ValueHolder<Interpolation> BOUNCE_INOUT = INTERPOLATIONS.register(Interpolation.of("bounce_inout", ctx -> {
        float f = ctx.x() < 0.5f ? 1.0f - Interpolations.bounce(1.0f - 2.0f * ctx.x(), 0.0f, 1.0f) : 1.0f + Interpolations.bounce(2.0f * ctx.x() - 1.0f, 0.0f, 1.0f);
        return ctx.lerp(f / 2.0f);
    }));
    public static final ValueHolder<Interpolation> SINE_IN = INTERPOLATIONS.register(Interpolation.of("sine_in", ctx -> ctx.lerp(1.0f - Mth.m_14089_((float)(ctx.x() * (float)Math.PI / 2.0f)))));
    public static final ValueHolder<Interpolation> SINE_OUT = INTERPOLATIONS.register(Interpolation.of("sine_out", ctx -> ctx.lerp(Mth.m_14031_((float)(ctx.x() * (float)Math.PI / 2.0f)))));
    public static final ValueHolder<Interpolation> SINE_INOUT = INTERPOLATIONS.register(Interpolation.of("sine_inout", ctx -> ctx.lerp(-0.5f * (Mth.m_14089_((float)((float)Math.PI * ctx.x())) - 1.0f))));
    public static final ValueHolder<Interpolation> CIRCLE_IN = INTERPOLATIONS.register(Interpolation.of("circle_in", ctx -> ctx.lerp(1.0f - Mth.m_14116_((float)(1.0f - MtMath.pow(Mth.m_14036_((float)ctx.x(), (float)0.0f, (float)1.0f), 2.0f))))));
    public static final ValueHolder<Interpolation> CIRCLE_OUT = INTERPOLATIONS.register(Interpolation.of("circle_out", ctx -> ctx.lerp(Mth.m_14116_((float)(1.0f - MtMath.pow(Mth.m_14036_((float)ctx.x(), (float)0.0f, (float)1.0f) - 1.0f, 2.0f))))));
    public static final ValueHolder<Interpolation> CIRCLE_INOUT = INTERPOLATIONS.register(Interpolation.of("circle_inout", ctx -> {
        float x2 = Mth.m_14036_((float)ctx.x(), (float)0.0f, (float)1.0f);
        float f = x2 < 0.5f ? 1.0f - Mth.m_14116_((float)(1.0f - MtMath.pow(2.0f * x2, 2.0f))) : Mth.m_14116_((float)(1.0f - MtMath.pow(-2.0f * x2 + 2.0f, 2.0f))) + 1.0f;
        return ctx.lerp(f / 2.0f);
    }));
    public static final ValueHolder<Interpolation> CUBIC = INTERPOLATIONS.register(Interpolation.of("cubic", ctx -> {
        float x2 = Mth.m_14207_((float)ctx.x());
        float x3 = x2 * ctx.x();
        return 0.5f * (2.0f * ctx.current() + (-ctx.last() + ctx.next()) * ctx.x() + (2.0f * ctx.last() - 5.0f * ctx.current() + 4.0f * ctx.next() - ctx.postNext()) * x2 + (-ctx.last() + 3.0f * ctx.current() - 3.0f * ctx.next() + ctx.postNext()) * x3);
    }));
    public static final ValueHolder<Interpolation> CATMULLROM = INTERPOLATIONS.register(Interpolation.of("catmullrom", ctx -> Mth.m_216244_((float)ctx.x(), (float)ctx.last(), (float)ctx.current(), (float)ctx.next(), (float)ctx.postNext())));
    public static final ValueHolder<Interpolation> HERMITE = INTERPOLATIONS.register(new HermiteInterpolation());

    private static float bounce(float x, float a, float b) {
        float f = 7.5625f;
        float f1 = 2.75f;
        float x2 = x < 1.0f / f1 ? f * x * x : (x < 2.0f / f1 ? f * (x -= 1.5f / f1) * x + 0.75f : (x < 2.5f / f1 ? f * (x -= 2.25f / f1) * x + 0.9375f : f * (x -= 2.625f / f1) * x + 0.984375f));
        return Mth.m_14179_((float)x2, (float)a, (float)b);
    }
}

