/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.interpolation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mr_toad.lib.mtjava.floats.func.ToFloatFunction;
import com.mr_toad.lib.mtjava.math.interpolation.InterpolationContext;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolations;
import net.minecraft.network.chat.Component;

public interface Interpolation {
    public static Interpolation of(final String name, final ToFloatFunction<InterpolationContext> getter) {
        return new Interpolation(){

            @Override
            public float interpolate(InterpolationContext ctx) {
                return getter.applyAsFloat(ctx);
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public Codec<Interpolation> codec() {
                return RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("interpolation").forGetter(Interpolations.INTERPOLATIONS::getIdOrThrow)).apply((Applicative)instance, id -> (Interpolation)Interpolations.INTERPOLATIONS.getOrThrow(id).get()));
            }
        };
    }

    public float interpolate(InterpolationContext var1);

    public String name();

    public Codec<Interpolation> codec();

    default public float interpolate(float last, float current, float next, float postNext, float x) {
        return this.interpolate(new InterpolationContext(last, current, next, postNext, x));
    }

    default public Component getName() {
        return Component.m_237115_((String)("toadlib.interpolation." + this.name()));
    }

    default public Component getTooltip() {
        return Component.m_237115_((String)("toadlib.interpolation." + this.name() + ".tooltip"));
    }
}

